/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.state;

import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.particle.ParticleAnimationHandler;
import dev.tauri.jsg.renderer.stargate.StargateOrlinRendererState;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.orlin.StargateOrlinOpeningParticleScenes;
import dev.tauri.jsg.state.stargate.StargateOrlinParticleState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StargateOrlinStateManager
extends StargateAbstractStateManager<StargateOrlinBaseBE, StargateOrlinRendererState> {
    public ParticleAnimationHandler<StargateOrlinBaseBE> particleHandler = new ParticleAnimationHandler();

    public StargateOrlinStateManager(StargateOrlinBaseBE stargate) {
        super(stargate);
    }

    @Override
    protected StargateChevronsState generateChevronsState() {
        return new StargateChevronsState(this){

            @Override
            @ParametersAreNonnullByDefault
            @NotNull
            protected StargateChevronsState.ChevronState getEmptyState(StargateAbstractStateManager<?, ?> stateManager, ChevronEnum ch) {
                return new StargateChevronsState.ChevronState(stateManager, LoadersHolder.JSG_HOLDER.texture(), "milkyway/chevron", ch);
            }

            @Override
            @ParametersAreNonnullByDefault
            @NotNull
            protected StargateChevronsState.ChevronState chevronStateFromNBT(StargateAbstractStateManager<?, ?> stateManager, CompoundTag tag) {
                return new StargateChevronsState.ChevronState(stateManager, LoadersHolder.JSG_HOLDER.texture(), "milkyway/chevron", tag);
            }

            @Override
            @ParametersAreNonnullByDefault
            @NotNull
            protected StargateChevronsState.ChevronState chevronStateFromBytes(StargateAbstractStateManager<?, ?> stateManager, ByteBuf buff) {
                return new StargateChevronsState.ChevronState(stateManager, LoadersHolder.JSG_HOLDER.texture(), "milkyway/chevron", buff);
            }

            @Override
            @ParametersAreNonnullByDefault
            public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
                super.executeTask(scheduledTask, customData);
                if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP) {
                    List<ChevronEnum> chevrons = customData.m_128471_("litAll") ? Arrays.stream(ChevronEnum.values()).toList() : List.of(ChevronEnum.valueOf(customData.m_128451_("chevron")));
                    StargateOrlinStateManager.this.sendState(StateType.ORLIN_PARTICLE_STATE, new StargateOrlinParticleState(chevrons));
                }
            }
        };
    }

    @Override
    public State createState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.RENDERER_STATE, this::createRendererStateClient).tryType(StateType.ORLIN_PARTICLE_STATE, StargateOrlinParticleState::new).orElseGet(() -> super.createState(stateType));
    }

    @Override
    public State getState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.RENDERER_STATE, () -> this.getRendererStateServer().build()).tryType(StateType.ORLIN_PARTICLE_STATE, StargateOrlinParticleState::new).orElseGet(() -> super.getState(stateType));
    }

    @Override
    public void setState(StateType stateType, State state) {
        stateType.stateExecutor().tryType(StateType.ORLIN_PARTICLE_STATE, () -> {
            StargateOrlinParticleState particleState = (StargateOrlinParticleState)state;
            if (particleState.breakEffect) {
                return;
            }
            for (ChevronEnum chevron : particleState.chevrons) {
                this.particleHandler.play(StargateOrlinOpeningParticleScenes.CHEVRON.apply(chevron));
            }
        }).tryType(StateType.RENDERER_UPDATE, () -> {
            super.setState(stateType, state);
            if (((StargateRendererActionState)state).action == StargateRendererActionState.EnumGateAction.CLOSE_GATE) {
                this.particleHandler.clear();
            }
            if (((StargateRendererActionState)state).action == StargateRendererActionState.EnumGateAction.OPEN_GATE) {
                this.particleHandler.play(StargateOrlinOpeningParticleScenes.SMOKE.get());
            }
        }).runOrElse(() -> super.setState(stateType, state));
    }

    @Override
    protected StargateOrlinRendererState.StargateOrlinRendererStateBuilder getRendererStateServer() {
        return (StargateOrlinRendererState.StargateOrlinRendererStateBuilder)new StargateOrlinRendererState.StargateOrlinRendererStateBuilder().setStargateState(((StargateOrlinBaseBE)this.stargate).getDialingManager().getStargateState());
    }

    @Override
    protected StargateOrlinRendererState createRendererStateClient() {
        return new StargateOrlinRendererState();
    }

    @Override
    public void tick(@NotNull Level level) {
        super.tick(level);
        this.particleHandler.tick((StargateOrlinBaseBE)this.stargate);
    }
}

