/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network.symbol;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.client.screen.ITab;
import dev.tauri.jsg.api.client.screen.ITabAddress;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SymbolUniverseProvider
extends AbstractSymbolType<SymbolUniverseEnum> {
    private static final Map<Integer, SymbolUniverseEnum> ID_MAP = new HashMap<Integer, SymbolUniverseEnum>();
    private static final Map<String, SymbolUniverseEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolUniverseEnum>();

    @Override
    public SymbolUniverseEnum getFirstValidForAddress() {
        return SymbolUniverseEnum.G1;
    }

    @Override
    public IPointOfOriginType getPointOfOriginType() {
        return StargateTypes.UNIVERSE;
    }

    @Override
    public SymbolUniverseEnum getBRB() {
        return null;
    }

    @Override
    public int[] getAncientTitlePos() {
        return new int[]{330, 36};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITab.ITabBuilder finalizeAddressTab(ITab.ITabBuilder builder) {
        return builder.setTexture(JSGApi.rl("textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 44);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITabAddress.SymbolCoords getSymbolCoords(int symbol) {
        return new ITabAddress.SymbolCoords(24 + 16 * (symbol % 6), 20 + 45 * (symbol / 6));
    }

    @Override
    public float getAnglePerGlyph() {
        return 8.0f;
    }

    @Override
    public SymbolUniverseEnum getSymbolByAngle(float angle, float bounds) {
        SymbolUniverseEnum closest = null;
        float closestAngle = Float.MAX_VALUE;
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        angle %= 360.0f;
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            float diffAngle = Math.abs((float)symbol.angle - angle);
            if (closestAngle > diffAngle) {
                closestAngle = diffAngle;
                closest = symbol;
            }
            if (closestAngle > (diffAngle = Math.abs((float)(symbol.angle + 360) - angle))) {
                closestAngle = diffAngle;
                closest = symbol;
            }
            if (!(closestAngle > (diffAngle = Math.abs((float)symbol.angle - (angle + 360.0f))))) continue;
            closestAngle = diffAngle;
            closest = symbol;
        }
        return closest;
    }

    @Override
    public float getAngleOfNearest(float angle) {
        int end = 38;
        int loops = 0;
        int temp = end;
        for (int current = 0; current < end; ++current) {
            temp = end - current;
            if (!(angle < this.getAngleByAngIndex(temp) && angle < this.getAngleByAngIndex(temp - 1)) && angle != this.getAngleByAngIndex(temp)) continue;
            return this.getAngleByAngIndex(temp);
        }
        return this.getAngleByAngIndex(temp);
    }

    @Override
    public float getAngleByAngIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > 36) {
            index = 36;
        }
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (symbol.angleIndex != index) continue;
            return symbol.angle;
        }
        return 0.0f;
    }

    public SymbolUniverseEnum[] getValues() {
        return SymbolUniverseEnum.values();
    }

    @Override
    public Block getBaseBlock() {
        return (Block)BlockRegistry.STARGATE_UNIVERSE_BASE_BLOCK.get();
    }

    @Override
    public Item getGlyphUpgrade() {
        return (Item)ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get();
    }

    @Override
    public Block getDHDBlock() {
        return null;
    }

    @Override
    public String getId() {
        return "universe";
    }

    @Override
    public int getIconWidth() {
        return 20;
    }

    @Override
    public int getIconHeight() {
        return 42;
    }

    @Override
    public SymbolUniverseEnum getRandomSymbol(Random random) {
        int id;
        while (this.valueOf(id = random.nextInt(36) + 1) == null || !this.valueOf(id).isValidForAddress() || id == this.getOrigin().getId()) {
        }
        return this.valueOf(id);
    }

    @Override
    public boolean validateDialedAddress(IAddress stargateAddress) {
        if (stargateAddress.getSize() < 7) {
            return false;
        }
        return stargateAddress.get(stargateAddress.getSize() - 1).origin();
    }

    @Override
    public int getMinimalSymbolCountTo(AbstractSymbolType<?> symbolType, boolean localDial) {
        if (JSGConfig.Stargate.useStrictSevenSymbolsUniGate.get()) {
            localDial = true;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
            return 9;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
            return 9;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
            return localDial ? 7 : 8;
        }
        return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.UNIVERSE, localDial);
    }

    @Override
    public SymbolUniverseEnum getOrigin() {
        return SymbolUniverseEnum.G17;
    }

    @Override
    public int getMaxSymbolsDisplay(boolean hasUpgrade) {
        return hasUpgrade ? 8 : 6;
    }

    @Override
    public SymbolUniverseEnum getTopSymbol() {
        return SymbolUniverseEnum.TOP_CHEVRON;
    }

    @Override
    public SymbolUniverseEnum valueOf(int id) {
        return ID_MAP.get(id);
    }

    @Override
    public SymbolUniverseEnum fromEnglishName(String englishName) {
        SymbolUniverseEnum symbol = ENGLISH_NAME_MAP.get(englishName.toLowerCase());
        if (symbol != null) {
            return symbol;
        }
        try {
            int index = Integer.parseInt(englishName.replace("G", ""));
            if (index < 1 || index > 36) {
                return null;
            }
            return SymbolUniverseEnum.values()[index];
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    static {
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            ID_MAP.put(symbol.id, symbol);
            ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
        }
        ENGLISH_NAME_MAP.put("point of origin", SymbolUniverseEnum.G17);
    }
}

