/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.manager.IStargateRIGManager;
import dev.tauri.jsg.api.stargate.rig.IRIGWave;
import dev.tauri.jsg.config.stargate.StargateRIGConfig;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.rig.RIGInstance;
import dev.tauri.jsg.stargate.rig.RIGWave;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateRIGManager
extends AbstractStargateManager<Stargate<?>>
implements IStargateRIGManager {
    public final LinkedList<RIGWave> waves = new LinkedList();
    private RIGInstance rigInstance;

    public StargateRIGManager(Stargate<?> stargate) {
        super(stargate);
        this.init();
    }

    private void init() {
        this.waves.clear();
        Collection configWaves = StargateRIGConfig.INSTANCE.configEntries.values();
        for (RIGWave wave : configWaves) {
            if (!wave.allowedOnGates.contains(this.stargate.getStargateType().toString())) continue;
            for (int i = 0; i < wave.weight; ++i) {
                this.waves.addLast(wave);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.rigInstance != null && this.rigInstance.isRunning();
    }

    @Override
    public boolean isGateActive() {
        return this.rigInstance != null && this.rigInstance.isGateActive();
    }

    @Override
    public boolean canStart() {
        if (this.rigInstance != null) {
            return false;
        }
        if (this.waves.isEmpty()) {
            return false;
        }
        Level level = this.stargate.getStargateLevel();
        if (level == null) {
            return false;
        }
        if (!this.stargate.isRIGAllowed()) {
            return false;
        }
        return this.stargate.isMerged();
    }

    @Override
    @Nullable
    public RIGWave getRandomWave() {
        LinkedList<RIGWave> allowedWaves = new LinkedList<RIGWave>();
        Level level = this.stargate.getStargateLevel();
        if (level == null) {
            return null;
        }
        ResourceKey dim = level.m_46472_();
        Holder biome = level.m_204166_(this.stargate.blockPosition());
        for (RIGWave wave : this.waves) {
            if (wave.allowedInDims != null && !wave.allowedInDims.isEmpty() && !wave.allowedInDims.contains(dim.m_135782_().toString()) || wave.allowedBiomes != null && !wave.allowedBiomes.isEmpty() && wave.allowedBiomes.stream().noneMatch(e -> {
                if (e.startsWith("#")) {
                    return biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(e.replaceFirst("#", ""))));
                }
                return biome.m_203373_(new ResourceLocation(e));
            }) || wave.blacklistedBiomes != null && !wave.blacklistedBiomes.isEmpty() && wave.blacklistedBiomes.stream().anyMatch(e -> {
                if (e.startsWith("#")) {
                    return biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(e.replaceFirst("#", ""))));
                }
                return biome.m_203373_(new ResourceLocation(e));
            }) || !wave.allowedForDifficulties.contains(level.m_46791_())) continue;
            allowedWaves.addLast(wave);
        }
        if (allowedWaves.isEmpty()) {
            return null;
        }
        RandomSource random = level.m_213780_();
        return (RIGWave)allowedWaves.get(random.m_188503_(allowedWaves.size()));
    }

    @Override
    public void generateNewIncoming(@Nullable Boolean shouldOpenIris) {
        RIGWave wave = this.getRandomWave();
        if (wave == null) {
            return;
        }
        this.spawnNewIncoming(wave, wave.chevronsToDial, shouldOpenIris);
    }

    @Override
    public void spawnNewIncoming(@NotNull IRIGWave wave, int chevronCount, Boolean shouldOpenIris) {
        if (!this.stargate.getDialingManager().getStargateState().idle() || this.stargate.getStargateLevel() == null) {
            return;
        }
        RandomSource random = this.stargate.getStargateLevel().m_213780_();
        boolean openIris = shouldOpenIris != null && shouldOpenIris != false || (double)random.m_188501_() < wave.shouldOpenIrisChance();
        wave.setup(random);
        if (wave.hasFinished()) {
            return;
        }
        if (chevronCount > 9) {
            chevronCount = 9;
        }
        if (chevronCount < 7) {
            chevronCount = 7;
        }
        double animationLength = ((double)random.m_188503_(100) + 100.0) / 7.0 * (double)chevronCount;
        this.rigInstance = new RIGInstance(this, wave, chevronCount, (int)animationLength, openIris);
    }

    public void onUnload() {
        this.end();
    }

    @Override
    public void end() {
        if (this.rigInstance == null) {
            return;
        }
        this.rigInstance.end(true);
    }

    @Override
    public void tick(@NotNull Level level) {
        if (level.m_5776_()) {
            return;
        }
        if (this.rigInstance == null) {
            RandomSource rand;
            if (this.stargate.getDialingManager().getStargateState().idle() && level.m_46467_() % 40L == 0L && !this.stargate.isGateBurried() && (double)(rand = level.m_213780_()).m_188501_() < (double)5.0E-4f * JSGConfig.Stargate.rigChance.get() && this.canStart()) {
                this.generateNewIncoming(null);
            }
            return;
        }
        if (this.rigInstance.isRunning()) {
            this.rigInstance.tick();
        } else {
            this.rigInstance = null;
        }
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag compound) {
    }

    public static Optional<RIGWave> getWave(String id) {
        return Optional.ofNullable((RIGWave)StargateRIGConfig.INSTANCE.configEntries.get(id));
    }

    public static ArrayList<String> getWaves() {
        return new ArrayList<String>(StargateRIGConfig.INSTANCE.configEntries.keySet());
    }
}

