/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation.traveler;

import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.registry.tags.JSGEntitiesTags;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.teleportation.traveler.AbstractTraveler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class EntityTraveler<E extends Entity>
extends AbstractTraveler<E> {
    protected E entity;
    protected final Vec3 originalPos;
    protected final Vec3 originalMotion;
    protected final Vec3 destinationPos;
    protected final Vec3 destinationMotion;
    protected final float destinationYaw;

    public EntityTraveler(E entity, Vec3 destinationPos, Vec3 originalMotion, Vec3 destinationMotion, float destinationYaw, Stargate<?> sourceGate, Stargate<?> receivingGate, boolean isStatic) {
        super(sourceGate, receivingGate, isStatic);
        this.entity = entity;
        this.destinationMotion = destinationMotion;
        this.destinationPos = destinationPos;
        this.originalPos = entity.m_20182_();
        this.originalMotion = originalMotion;
        this.destinationYaw = destinationYaw;
    }

    @Override
    public boolean canBeSendToTarget() {
        return !this.get().m_6095_().m_204039_(JSGEntitiesTags.STARGATE_UNTRANSPORTABLE_ENTITIES);
    }

    @Override
    public E get() {
        return this.entity;
    }

    @Override
    public Vec3 getOriginalMotion() {
        return this.originalMotion;
    }

    @Override
    public Vec3 getDestinationMotion() {
        return this.destinationMotion;
    }

    @Override
    public void setMotion(Vec3 newMotion) {
        this.get().m_20256_(newMotion);
    }

    @Override
    public Vec3 getOriginalPos() {
        return this.originalPos;
    }

    @Override
    public Vec3 getDestinationPos() {
        return this.destinationPos;
    }

    @Override
    public void setPos(Vec3 newPos) {
        this.get().m_146884_(newPos);
        this.get().m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @Override
    public void setYaw(float yaw) {
        this.get().m_146922_(yaw);
    }

    @Override
    public void sendChangeDimension(ServerLevel targetLevel) {
        this.get().changeDimension(targetLevel, (ITeleporter)this.sourceGate.getEventHorizonManager().getTeleporter(this, traveler -> {}));
    }

    @Override
    public float getDestinationYaw() {
        return this.destinationYaw;
    }

    @Override
    public void killWrongTravel() {
        ((StargateEventHorizonManager)this.getTransmitter().getEventHorizonManager()).remove(this);
        this.get().m_20334_(0.0, 0.0, 0.0);
        this.get().m_6074_();
    }

    @Override
    public void killIris() {
        this.get().m_20334_(0.0, 0.0, 0.0);
        this.get().m_6074_();
    }

    @Override
    public void killKawoosh() {
        this.get().m_20334_(0.0, 0.0, 0.0);
        this.get().m_6074_();
    }

    @Override
    public void killUnstable() {
        this.get().m_20334_(0.0, 0.0, 0.0);
        this.get().m_6074_();
    }

    @Override
    public int hashCode() {
        return this.get().m_19879_();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EntityTraveler)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }
}

