/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation.traveler;

import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.registry.DamageTypeRegistry;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.teleportation.traveler.EntityTraveler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class LivingTraveler<E extends LivingEntity>
extends EntityTraveler<E> {
    public LivingTraveler(E entity, Vec3 destinationPos, Vec3 originalMotion, Vec3 destinationMotion, float destinationYaw, Stargate<?> sourceGate, Stargate<?> receivingGate, boolean isStatic) {
        super(entity, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, receivingGate, isStatic);
    }

    @Override
    public void killWrongTravel() {
        ((StargateEventHorizonManager)this.getTransmitter().getEventHorizonManager()).remove(this);
        if (!this.getTransmitter().getEventHorizonManager().isMovingTowardsGate(this.getOriginalMotion())) {
            return;
        }
        this.sourceGate.playSoundEvent(SoundEvent.WORMHOLE_GO);
        DamageTypeRegistry.killEntity(this.get(), DamageTypeRegistry.WRONG_SIDE);
    }

    @Override
    public void killIris() {
        DamageTypeRegistry.killEntity(this.get(), DamageTypeRegistry.IRIS);
    }

    @Override
    public void killKawoosh() {
        DamageTypeRegistry.killEntity(this.get(), DamageTypeRegistry.KAWOOSH);
    }

    @Override
    public void killUnstable() {
        DamageTypeRegistry.killEntity(this.get(), DamageTypeRegistry.UNSTABLE_EH);
    }
}

