/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.util.updater;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.config.JSGConfig;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.Util;

public class GetUpdate {
    public static final String ERROR_STRING = "Error was occurred while updating JSG!";
    public static final String URL_BASE = "https://justsgmod.eu/api/?api=curseforge&version=1.20.1";
    public static final String GET_NAME_URL = "https://justsgmod.eu/api/?api=curseforge&version=1.20.1&t=name";
    public static final String GET_DOWNLOAD_URL = "https://justsgmod.eu/api/?api=curseforge&version=1.20.1&t=url";
    public static final String DOWNLOAD_URL_USER = GetUpdate.getSiteContent("https://justsgmod.eu/api/?api=curseforge&version=1.20.1&t=url");
    public static UpdateResult LAST_UPDATE_RESULT;

    public static void checkForUpdateVoid() {
        LAST_UPDATE_RESULT = GetUpdate.checkForUpdate();
    }

    public static UpdateResult checkForUpdate() {
        String currentVersion = JSG.MOD_VERSION.replace("1.20.1-", "").toLowerCase().split("-")[0].replaceAll("-", "").replaceAll("alpha", "").replaceAll("beta", "");
        if (!JSGConfig.General.enableAutoUpdater.get()) {
            return new UpdateResult(EnumUpdateResult.DISABLED, currentVersion);
        }
        String webData = GetUpdate.getSiteContent(GET_NAME_URL);
        if (webData.equalsIgnoreCase(ERROR_STRING)) {
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 1");
        }
        String[] got = webData.split("-");
        if (got.length < 3) {
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 2");
        }
        String gotVersion = got[2];
        JSG.logger.info("Got updater version: " + gotVersion);
        String[] currentVersionSplit = currentVersion.split("\\.");
        String[] gotVersionSplit = gotVersion.split("\\.");
        try {
            for (int i = 0; i < 4; ++i) {
                if (gotVersionSplit.length < i + 1 || currentVersionSplit.length < i + 1) continue;
                if (Integer.parseInt(currentVersionSplit[i]) < Integer.parseInt(gotVersionSplit[i])) {
                    return new UpdateResult(EnumUpdateResult.NEWER_AVAILABLE, gotVersion);
                }
                if (Integer.parseInt(currentVersionSplit[i]) <= Integer.parseInt(gotVersionSplit[i])) continue;
                return new UpdateResult(EnumUpdateResult.UP_TO_DATE, gotVersion);
            }
        }
        catch (Exception e) {
            JSG.logger.warn("Error while checking for update!", e);
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 3");
        }
        return new UpdateResult(EnumUpdateResult.UP_TO_DATE, gotVersion);
    }

    public static void openWebsiteToClient(String url) {
        try {
            Util.m_137581_().m_137646_(url);
        }
        catch (Exception e) {
            JSG.logger.error("Couldn't open link", e);
        }
    }

    public static String getSiteContent(String link) {
        try {
            JSG.logger.info("Fetching data from " + link);
            URL url = new URL(link);
            Scanner sc = new Scanner(url.openStream());
            StringBuilder sb = new StringBuilder();
            while (sc.hasNext()) {
                sb.append(sc.next());
            }
            String result = sb.toString();
            JSG.logger.info("Fetched: " + result);
            result = result.replaceAll("<[^>]*>", "");
            return result;
        }
        catch (Exception e) {
            JSG.logger.error("Error while getting data from " + link);
            JSG.logger.error("Site content Exception", e);
            return ERROR_STRING;
        }
    }

    public static class UpdateResult {
        public EnumUpdateResult result;
        public final String response;

        public UpdateResult(EnumUpdateResult result, String newestVersion) {
            this.result = result;
            this.response = newestVersion;
        }
    }

    public static enum EnumUpdateResult {
        UP_TO_DATE,
        NEWER_AVAILABLE,
        ERROR,
        DISABLED;

    }
}

