/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.feature;

import com.mojang.serialization.Codec;
import dev.tauri.jsg.worldgen.feature.config.OreSpireConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class OreSpireFeature
extends Feature<OreSpireConfig> {
    public OreSpireFeature(Codec<OreSpireConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<OreSpireConfig> ctx) {
        OreSpireConfig config = (OreSpireConfig)ctx.m_159778_();
        BlockPos blockpos = ctx.m_159777_();
        RandomSource randomsource = ctx.m_225041_();
        WorldGenLevel worldgenlevel = ctx.m_159774_();
        while (!worldgenlevel.m_8055_(blockpos).m_204336_(config.canGrowFrom) && blockpos.m_123342_() > worldgenlevel.m_141937_() + 2) {
            blockpos = blockpos.m_7495_();
        }
        if (worldgenlevel.m_46859_(blockpos) || !worldgenlevel.m_8055_(blockpos).m_204336_(config.canProtrudeThrough)) {
            return false;
        }
        int spireLevels = config.levelsProvider.m_214085_(randomsource);
        int totalHeight = 0;
        HashMap<BlockPos, BlockState> blocksToPlace = new HashMap<BlockPos, BlockState>();
        for (int spireLevel = 0; spireLevel < spireLevels; ++spireLevel) {
            int currentCenterX = config.deformationProvider.m_214085_(randomsource);
            int currentCenterZ = config.deformationProvider.m_214085_(randomsource);
            int xDeformation = config.deformationProvider.m_214085_(randomsource);
            int zDeformation = config.deformationProvider.m_214085_(randomsource);
            int ySize = config.levelHeightProvider.m_214085_(randomsource);
            int levelRadius = 10 + spireLevels % 5 - spireLevel / 3;
            int xRadius = levelRadius + xDeformation;
            int zRadius = levelRadius + zDeformation;
            for (int y = 0; y <= ySize; ++y) {
                xRadius = this.adjustRadius(xRadius, ySize, y);
                zRadius = this.adjustRadius(zRadius, ySize, y);
                for (int x = -xRadius; x <= xRadius; ++x) {
                    for (int z = -zRadius; z <= zRadius; ++z) {
                        double zScale;
                        double xScale = Math.pow((double)(x - currentCenterX) / (double)xRadius, 2.0);
                        if (!(xScale + (zScale = Math.pow((double)(z - currentCenterZ) / (double)zRadius, 2.0)) < 1.0)) continue;
                        float chance = config.oreSpawnChanceProvider.m_214084_(randomsource);
                        if (!(randomsource.m_188501_() < chance ? !this.putOre(blocksToPlace, worldgenlevel, blockpos, x, y, z, totalHeight, config, randomsource) : !this.putFilling(blocksToPlace, worldgenlevel, blockpos, x, y, z, totalHeight, config, randomsource))) continue;
                        return false;
                    }
                }
            }
            totalHeight += ySize;
        }
        for (Map.Entry entry : blocksToPlace.entrySet()) {
            this.m_5974_((LevelWriter)worldgenlevel, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        return true;
    }

    protected boolean putOre(Map<BlockPos, BlockState> blocksToPlace, WorldGenLevel level, BlockPos blockpos, int x, int y, int z, int totalHeight, OreSpireConfig config, RandomSource randomsource) {
        BlockPos pos = blockpos.m_7918_(x, y + totalHeight, z);
        if (!level.m_180807_(pos)) {
            return false;
        }
        blocksToPlace.put(pos, config.oreProvider.m_213972_(randomsource, blockpos));
        return true;
    }

    protected boolean putFilling(Map<BlockPos, BlockState> blocksToPlace, WorldGenLevel level, BlockPos blockpos, int x, int y, int z, int totalHeight, OreSpireConfig config, RandomSource randomsource) {
        BlockPos pos = blockpos.m_7918_(x, y + totalHeight, z);
        if (!level.m_180807_(pos)) {
            return false;
        }
        blocksToPlace.put(pos, config.fillingProvider.m_213972_(randomsource, blockpos));
        return true;
    }

    protected int adjustRadius(int radius, int ySize, int y) {
        if (y == 0) {
            return radius + 2;
        }
        if (y == ySize) {
            return radius - 2;
        }
        if (y == 1) {
            return radius + 1;
        }
        if (y == ySize - 1) {
            return radius - 1;
        }
        return radius;
    }
}

