/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.generator;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.IConfigurable;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.power.JSGEnergyStorage;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.util.GeneratedStargate;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.api.util.blockentity.IUpgradable;
import dev.tauri.jsg.block.dialhomedevice.DHDAbstractBlock;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.multistructure.mergehelper.StargateAbstractMergeHelper;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;

public class StargateGenerator
implements IStargateGenerator {
    @Override
    public void setStargateEnergyInternalSmart(IStargateGenerator.PlacementConfig config, int energy) {
        int stargateCapacity = (int)((float)JSGConfig.Stargate.stargateEnergyStorage.get() / 4.0f);
        config.stargateEnergyInternal = Math.min(stargateCapacity, energy);
        for (int toCaps = energy - config.stargateEnergyInternal; toCaps > 0; toCaps -= stargateCapacity) {
            int capacity = Math.min(stargateCapacity, toCaps);
            config.capacitors.add((Pair<Integer, Boolean>)Pair.of((Object)capacity, (Object)false));
        }
    }

    @Override
    @Nullable
    public GeneratedStargate generateStargate(@Nonnull IStargateGenerator.PlacementConfig conf) {
        return this.generateStargate(conf, true);
    }

    @Override
    @Nullable
    public GeneratedStargate generateStargate(@Nonnull IStargateGenerator.PlacementConfig conf, boolean replaceMemberBlocks) {
        StargateAbstractBaseBE gateTile;
        if (conf.world == null) {
            return null;
        }
        if (conf.gateBasePos == null) {
            return null;
        }
        Block dhdBlock = conf.gateType.getDHDBlock();
        BlockState gateBaseBlockState = conf.gateType.getBaseBlock().m_49966_();
        Item crystalGlyphUpgrade = conf.gateType.symbolType.getGlyphUpgrade();
        if (!conf.baseInPlace) {
            conf.world.m_7731_(conf.gateBasePos, (BlockState)((BlockState)gateBaseBlockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)conf.gateFacing)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(conf.gateVerticalFacing))), 18);
        }
        try {
            gateTile = (StargateAbstractBaseBE)conf.world.m_7702_(conf.gateBasePos);
        }
        catch (Exception e) {
            JSG.logger.error("Error while generating gate at " + BlockHelper.blockPosToBetterString(conf.gateBasePos) + " in " + String.valueOf(conf.world.m_46472_()), e);
            return null;
        }
        if (gateTile == null) {
            return null;
        }
        StargateAbstractMergeHelper mergeHelper = gateTile.getMergeHelper();
        for (Map.Entry<BlockPos, BlockState> e : mergeHelper.getBlocks(true).entrySet()) {
            BlockState currentState = conf.world.m_8055_(e.getKey());
            if (!replaceMemberBlocks && currentState.m_60734_() == e.getValue().m_60734_()) continue;
            conf.world.m_7731_(e.getKey(), e.getValue(), 18);
            BlockEntity blockEntity = conf.world.m_7702_(e.getKey());
            if (!(blockEntity instanceof CamouflageBE)) continue;
            CamouflageBE camoBE = (CamouflageBE)blockEntity;
            camoBE.setCamoBlock(currentState);
        }
        mergeHelper.updateMemberStateAndCheck(true);
        gateTile.refresh();
        if (conf.stargateConfig != null && gateTile instanceof IConfigurable) {
            IConfigurable configTile = (IConfigurable)((Object)gateTile);
            configTile.setConfig(conf.stargateConfig.apply(configTile.getConfig()));
        }
        ((JSGEnergyStorage)((Object)gateTile.getEnergyManager().getStorage())).setEnergyStored(conf.stargateEnergyInternal);
        if (gateTile instanceof IUpgradable) {
            IUpgradable upgradable = (IUpgradable)((Object)gateTile);
            int nextSlot = 0;
            boolean isTypeCrystalIn = false;
            ItemHandlerHelper.clearInventory(upgradable.getItemHandler());
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_STARGATE)) {
                upgradable.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_STARGATE.get(), 1), false);
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_MW)) {
                upgradable.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get(), 1), false);
                if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get()) {
                    isTypeCrystalIn = true;
                }
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_PEG)) {
                upgradable.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get(), 1), false);
                if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get()) {
                    isTypeCrystalIn = true;
                }
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_UNI)) {
                upgradable.getItemHandler().insertItem(nextSlot++, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get(), 1), false);
                if (conf.gateType.symbolType.getGlyphUpgrade() == ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get()) {
                    isTypeCrystalIn = true;
                }
            }
            if (!isTypeCrystalIn && nextSlot < 4 && conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE)) {
                upgradable.getItemHandler().insertItem(nextSlot, new ItemStack((ItemLike)crystalGlyphUpgrade, 1), false);
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_IRIS_TITANIUM)) {
                upgradable.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS.get(), 1), false);
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_IRIS_TRINIUM)) {
                upgradable.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS_TRINIUM.get(), 1), false);
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_SHIELD)) {
                upgradable.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_SHIELD.get(), 1), false);
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_IRIS_CREATIVE)) {
                upgradable.getItemHandler().insertItem(11, new ItemStack((ItemLike)ItemRegistry.UPGRADE_IRIS_CREATIVE.get(), 1), false);
            }
            nextSlot = 4;
            for (Pair<Integer, Boolean> e : conf.capacitors) {
                ItemStack capacitor;
                if (nextSlot >= 7) break;
                if (((Boolean)e.second()).booleanValue()) {
                    capacitor = new ItemStack((ItemLike)BlockRegistry.CAPACITOR_BLOCK_CREATIVE.get());
                } else {
                    if ((Integer)e.first() < 0) continue;
                    capacitor = new ItemStack((ItemLike)BlockRegistry.CAPACITOR_BLOCK.get());
                    IEnergyStorage storage = (IEnergyStorage)capacitor.getCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow();
                    storage.receiveEnergy(((Integer)e.first()).intValue(), false);
                }
                upgradable.getItemHandler().insertItem(nextSlot++, capacitor, false);
            }
        }
        if (gateTile instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE classicTile = (StargateClassicBaseBE)gateTile;
            classicTile.updatePowerTier();
            classicTile.getIrisManager().setIrisMode(conf.irisMode);
            classicTile.getIrisManager().setIrisCode(conf.irisCode);
        }
        if (conf.dhdPos != null && dhdBlock != null) {
            BlockState dhdState = conf.world.m_8055_(conf.dhdPos);
            if (!(dhdState.m_60734_() instanceof DHDAbstractBlock)) {
                int dhdRotation = conf.dhdRotation;
                if (dhdRotation < 0) {
                    dhdRotation = BlockPosHelper.getIntDHDRotationFromFacing(conf.gateFacing, conf.gateFacing == Direction.WEST || conf.gateFacing == Direction.EAST);
                }
                BlockState dhdBlockState = (BlockState)dhdBlock.m_49966_().m_61124_((Property)JSGProperties.ROTATION_PROPERTY, (Comparable)Integer.valueOf(dhdRotation));
                conf.world.m_7731_(conf.dhdPos, dhdBlockState, 18);
            }
            DHDAbstractBE dhdTile = (DHDAbstractBE)Objects.requireNonNull(conf.world.m_7702_(conf.dhdPos));
            ItemStack crystal = new ItemStack((ItemLike)dhdTile.getControlCrystal());
            dhdTile.getItemStackHandler().setStackInSlot(0, crystal);
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(1, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_DHD.get(), 1));
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_CAPACITY_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(2, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_UPGRADE_CAPACITY.get(), 1));
            }
            if (conf.upgrades.contains((Object)IStargateGenerator.StargateUpgradesEnum.UPGRADE_EFFICIENCY_DHD)) {
                dhdTile.getItemStackHandler().setStackInSlot(3, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_UPGRADE_EFFICIENCY.get(), 1));
            }
            if (conf.dhdFluid >= 0) {
                dhdTile.getFluidHandler().setFluid(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), conf.dhdFluid));
            }
            LinkingHelper.updateLinkedGate(conf.world, conf.gateBasePos, conf.dhdPos);
        }
        ResourceLocation biomePath = conf.world.m_204166_(conf.gateBasePos).m_203543_().orElse(Biomes.f_48205_).m_135782_();
        StargateAddress gateAddress = gateTile.getStargateAddress(conf.addressSymbolTypeToReturn);
        return new GeneratedStargate(gateAddress, biomePath.m_135815_(), true, gateTile.getPointOfOrigin());
    }
}

