/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.poolinject.injectors;

import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.worldgen.poolinject.TemplatePoolInjector;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class StargateTemplatePoolsAdditions {
    public static final ResourceLocation PROCESSOR_OFFSET_NEUTRAL = new ResourceLocation("jsg", "surface_issues");
    public static final ResourceLocation PROCESSOR_OFFSET_1_DOWN = new ResourceLocation("jsg", "offset_1_down");
    public static final ResourceLocation PROCESSOR_OFFSET_1_UP = new ResourceLocation("jsg", "offset_1_up");
    public static final ResourceLocation PROCESSOR_OFFSET_2_DOWN = new ResourceLocation("jsg", "offset_2_down");
    public static final ResourceLocation PROCESSOR_MOSSY_10_OFFSET_1_DOWN = new ResourceLocation("jsg", "mosify_10_with_offset_1_down");
    public static final ResourceLocation PROCESSOR_MOSSY_20_OFFSET_1_DOWN = new ResourceLocation("jsg", "mosify_20_with_offset_1_down");
    public static final ResourceLocation PROCESSOR_MOSSY_10_OFFSET_2_DOWN = new ResourceLocation("jsg", "mosify_10_with_offset_2_down");
    public static final ResourceLocation PROCESSOR_MOSSY_20_OFFSET_2_DOWN = new ResourceLocation("jsg", "mosify_20_with_offset_2_down");

    public static void register() {
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MILKYWAY, List.of("desert", "plains", "snowy", "nether"), 4);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MILKYWAY, List.of("mangrove"), 4, PROCESSOR_MOSSY_20_OFFSET_1_DOWN);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MILKYWAY, List.of("mossy"), 4, PROCESSOR_MOSSY_10_OFFSET_1_DOWN);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MILKYWAY, List.of("badlands"), 3);
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("badlands"), "in_mountain_1");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("badlands"), "in_mountain_2");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("badlands"), "burried");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("desert"), "burried");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("mangrove"), "burried", PROCESSOR_MOSSY_20_OFFSET_1_DOWN);
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("mossy"), "burried", PROCESSOR_MOSSY_10_OFFSET_1_DOWN);
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("plains"), "burried");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("plains"), "horizontal");
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MILKYWAY, List.of("snowy"), "burried");
        StargateTemplatePoolsAdditions.addBases(StargateTypes.PEGASUS, List.of("badlands", "desert", "plains", "snowy"), 4, PROCESSOR_OFFSET_2_DOWN);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.PEGASUS, List.of("mangrove"), 4, PROCESSOR_MOSSY_20_OFFSET_2_DOWN);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.PEGASUS, List.of("mossy"), 4, PROCESSOR_MOSSY_10_OFFSET_2_DOWN);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.PEGASUS, List.of("ocean"), 4);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.UNIVERSE, List.of("end"), 4);
        StargateTemplatePoolsAdditions.addBase(StargateTypes.UNIVERSE, List.of("end_main_island"), "main_island", PROCESSOR_OFFSET_NEUTRAL);
        StargateTemplatePoolsAdditions.addBase(StargateTypes.MOVIE, List.of("desert"), "buried");
        new TemplatePoolInjector.Builder().addPool(new ResourceLocation("jsg", "abydos/main_pyramid/gateroom_gate_sections")).addAddition("jsg:abydos/main_pyramid/gateroom_gate_{stargate_size}", 1).submit();
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MILKYWAY, List.of("compat"), 1);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.PEGASUS, List.of("compat"), 1);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.UNIVERSE, List.of("compat"), 1);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.TOLLAN, List.of("compat"), 1);
        StargateTemplatePoolsAdditions.addBases(StargateTypes.MOVIE, List.of("compat"), 1);
    }

    private static void addBases(ResourceLocation pool, String path, int count) {
        TemplatePoolInjector.Builder injector = new TemplatePoolInjector.Builder();
        injector.addPool(pool);
        for (int i = 1; i <= count; ++i) {
            injector.addAddition("jsg:stargate/parts/" + path + "/base_" + i, 1, false);
        }
        injector.submit();
    }

    private static void addBases(ResourceLocation pool, String path, int count, ResourceLocation proceesor) {
        TemplatePoolInjector.Builder injector = new TemplatePoolInjector.Builder();
        injector.addPool(pool);
        for (int i = 1; i <= count; ++i) {
            injector.addAddition("jsg:stargate/parts/" + path + "/base_" + i, 1, false, proceesor);
        }
        injector.submit();
    }

    private static void addBases(StargateType stargateType, List<String> biomes, int count) {
        for (String biome : biomes) {
            StargateTemplatePoolsAdditions.addBases(new ResourceLocation("jsg", "stargate/parts/" + stargateType.textId + "/common/bases/" + biome), stargateType.textId + "/{stargate_size}/bases/" + biome, count);
        }
    }

    private static void addBases(StargateType stargateType, List<String> biomes, int count, ResourceLocation processor) {
        for (String biome : biomes) {
            StargateTemplatePoolsAdditions.addBases(new ResourceLocation("jsg", "stargate/parts/" + stargateType.textId + "/common/bases/" + biome), stargateType.textId + "/{stargate_size}/bases/" + biome, count, processor);
        }
    }

    private static void addBase(StargateType stargateType, List<String> biomes, String structName) {
        for (String biome : biomes) {
            TemplatePoolInjector.Builder injector = new TemplatePoolInjector.Builder();
            injector.addPool(new ResourceLocation("jsg", "stargate/parts/" + stargateType.textId + "/common/bases/" + biome)).addAddition("jsg:stargate/parts/" + stargateType.textId + "/{stargate_size}/bases/" + biome + "/" + structName, 1, false).submit();
        }
    }

    private static void addBase(StargateType stargateType, List<String> biomes, String structName, ResourceLocation processor) {
        for (String biome : biomes) {
            new TemplatePoolInjector.Builder().addPool(new ResourceLocation("jsg", "stargate/parts/" + stargateType.textId + "/common/bases/" + biome)).addAddition("jsg:stargate/parts/" + stargateType.textId + "/{stargate_size}/bases/" + biome + "/" + structName, 1, false, processor).submit();
        }
    }
}

