/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.structure;

import com.google.common.collect.Lists;
import dev.tauri.jsg.JSG;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JSGJigsawPlacement
extends JigsawPlacement {
    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, BlockPos blockPos, boolean flag, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Rotation rotation) {
        BlockPos blockpos;
        RegistryAccess registryaccess = context.f_226621_();
        ChunkGenerator chunkgenerator = context.f_226622_();
        StructureTemplateManager structuretemplatemanager = context.f_226625_();
        LevelHeightAccessor levelheightaccessor = context.f_226629_();
        WorldgenRandom worldgenrandom = context.f_226626_();
        Registry registry = registryaccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)startPool.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            ResourceLocation resourcelocation = startJigsawName.get();
            Optional optional = JSGJigsawPlacement.m_227247_((StructurePoolElement)structurepoolelement, (ResourceLocation)resourcelocation, (BlockPos)blockPos, (Rotation)rotation, (StructureTemplateManager)structuretemplatemanager, (WorldgenRandom)worldgenrandom);
            if (optional.isEmpty()) {
                JSG.logger.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)((ResourceKey)startPool.m_203543_().get()).m_135782_());
                return Optional.empty();
            }
            blockpos = (BlockPos)optional.get();
        } else {
            blockpos = blockPos;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)blockPos);
        BlockPos blockpos1 = blockPos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = projectStartToHeightmap.isPresent() ? blockPos.m_123342_() + chunkgenerator.m_223221_(i, j, projectStartToHeightmap.get(), levelheightaccessor, context.f_226624_()) : blockpos1.m_123342_();
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        int i1 = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (size > 0) {
                AABB aabb = new AABB((double)(i - maxDistanceFromCenter), (double)(i1 - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(i1 + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                JSGJigsawPlacement.m_227210_((RandomState)context.f_226624_(), (int)size, (boolean)flag, (ChunkGenerator)chunkgenerator, (StructureTemplateManager)structuretemplatemanager, (LevelHeightAccessor)levelheightaccessor, (RandomSource)worldgenrandom, (Registry)registry, (PoolElementStructurePiece)poolelementstructurepiece, (List)list, (VoxelShape)voxelshape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).m_142679_(arg_0));
            }
        }));
    }
}

