/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class StandardChickenModel<T extends Entity>
extends ChickenModel<T>
implements EasyNPCModel<T>,
ArmedModel {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, Rotations> modelPartRotationMap = new EnumMap<ModelPartType, Rotations>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart beak;
    private final ModelPart redThing;

    public StandardChickenModel(ModelPart modelPart) {
        super(modelPart);
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.beak = this.defineModelPart(ModelPartType.BEAK, modelPart, "beak");
        this.redThing = this.defineModelPart(ModelPartType.RED_THING, modelPart, "red_thing");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
        this.rightWing = this.defineModelPart(ModelPartType.RIGHT_WING, modelPart, "right_wing");
        this.leftWing = this.defineModelPart(ModelPartType.LEFT_WING, modelPart, "left_wing");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
        this.resetModelPart(ModelPartType.RIGHT_WING, this.rightWing);
        this.resetModelPart(ModelPartType.LEFT_WING, this.leftWing);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        this.beak.m_104315_(this.head);
        this.redThing.m_104315_(this.head);
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.f_104203_ = headPitch * ((float)Math.PI / 180);
        headPart.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftWing, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightWing, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.modelPartPositionMap.put(modelPartType, customPosition);
    }

    @Override
    public void setDefaultModelPartRotation(ModelPartType modelPartType, Rotations rotations) {
        this.modelPartRotationMap.put(modelPartType, rotations);
    }

    @Override
    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    @Override
    public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.modelPartPositionMap.getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    @Override
    public Rotations getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.modelPartRotationMap.getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    @Override
    public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.getOrDefault((Object)modelPartType, null);
    }

    private ModelPart getArm(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.leftWing : this.rightWing;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.getArm(humanoidArm).m_104299_(poseStack);
        poseStack.m_85837_(0.0, -0.2, 0.1);
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_85837_(0.0625, 0.0, 0.0);
    }
}

