/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseColorableAgeableListModel;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class StandardWolfModel<T extends Entity>
extends BaseColorableAgeableListModel<T>
implements HeadedModel {
    private final ModelPart upperBody;

    public StandardWolfModel(ModelPart modelPart) {
        super(modelPart);
        this.upperBody = this.defineModelPart(ModelPartType.UPPER_BODY, modelPart, "upper_body");
        ModelPart realHead = this.head.m_171324_("real_head");
        ModelPart realTail = this.tail.m_171324_("real_tail");
    }

    @Override
    public void resetModelParts() {
        super.resetModelParts();
        this.resetModelPart(ModelPartType.UPPER_BODY, this.upperBody);
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tail.f_104204_ = attackData.isAggressive() ? 0.0f : Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        return true;
    }

    @Override
    public boolean animateModelFrontLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean animateModelHindLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
        this.upperBody.f_104203_ = 1.2566371f;
        this.upperBody.f_104204_ = 0.0f;
        this.body.m_104227_(0.0f, 18.0f, 0.0f);
        this.body.f_104203_ = 0.7853982f;
        this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
        this.rightHindLeg.m_104227_(-2.5f, 22.7f, 2.0f);
        this.rightHindLeg.f_104203_ = 4.712389f;
        this.leftHindLeg.m_104227_(0.5f, 22.7f, 2.0f);
        this.leftHindLeg.f_104203_ = 4.712389f;
        this.rightFrontLeg.f_104203_ = 5.811947f;
        this.rightFrontLeg.m_104227_(-2.49f, 17.0f, -4.0f);
        this.leftFrontLeg.f_104203_ = 5.811947f;
        this.leftFrontLeg.m_104227_(0.51f, 17.0f, -4.0f);
        return true;
    }

    @Override
    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg, this.tail, this.upperBody);
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

