/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.objective.ObjectiveConfigurationScreen;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.configuration.objective.FollowObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FollowObjectiveConfigurationScreen
extends ObjectiveConfigurationScreen<FollowObjectiveConfigurationMenu> {
    protected final OwnerData<?> ownerData;
    protected Checkbox followOwnerCheckbox;
    protected Checkbox followPlayerCheckbox;
    protected EditBox followPlayerName;
    protected Button followPlayerNameSaveButton;
    protected Checkbox followEntityCheckbox;
    protected EditBox followEntityUUID;
    protected Button followEntityUUIDSaveButton;

    public FollowObjectiveConfigurationScreen(FollowObjectiveConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.ownerData = this.easyNPC.getEasyNPCOwnerData();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.followObjectiveButton.f_93623_ = false;
        int objectiveEntriesTop = this.contentTopPos + 5;
        this.followOwnerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop, ObjectiveType.FOLLOW_OWNER.getObjectiveName(), this.ownerData.getOwnerName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_OWNER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_OWNER, 6);
            objectiveDataEntry.setTargetOwnerUUID(this.ownerData.m_21805_());
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.followPlayerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_PLAYER.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER, 7);
            if (this.followPlayerName != null) {
                objectiveDataEntry.setTargetPlayerName(this.followPlayerName.m_94155_());
                this.followPlayerName.m_94186_(checkbox.selected());
            }
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.f_93623_ = checkbox.selected();
            }
            if (!checkbox.selected()) {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            } else if (!this.followPlayerName.m_94155_().isEmpty()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.followOwnerCheckbox.f_93623_ = this.ownerData.hasOwner();
        this.followPlayerName = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, this.contentLeftPos + 150, objectiveEntriesTop, 125));
        this.followPlayerName.m_94186_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER));
        this.followPlayerName.m_94151_(value -> {
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.f_93623_ = value != null && !value.isEmpty();
            }
        });
        this.followPlayerName.m_94144_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER) ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_PLAYER).getTargetPlayerName() : "");
        this.followPlayerNameSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.followPlayerName.m_252754_() + this.followPlayerName.m_5711_() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER);
            objectiveDataEntry.setTargetPlayerName(this.followPlayerName.m_94155_());
            ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
        }));
        this.followEntityCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_ENTITY_BY_UUID.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            if (this.followEntityUUID != null) {
                if (!this.followEntityUUID.m_94155_().isEmpty()) {
                    UUID entityUUID = null;
                    try {
                        entityUUID = UUID.fromString(this.followEntityUUID.m_94155_());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to parse UUID {} for {}", (Object)this.followEntityUUID.m_94155_(), (Object)this.uuid);
                    }
                    if (entityUUID != null) {
                        objectiveDataEntry.setTargetEntityUUID(entityUUID);
                    }
                }
                this.followEntityUUID.m_94186_(checkbox.selected());
            }
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.f_93623_ = checkbox.selected();
            }
            if (!checkbox.selected()) {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            } else if (!this.followEntityUUID.m_94155_().isEmpty()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.followEntityUUID = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, this.contentLeftPos + 150, objectiveEntriesTop, 125));
        this.followEntityUUID.m_94199_(36);
        this.followEntityUUID.m_94186_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID));
        this.followEntityUUID.m_94151_(value -> {
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.f_93623_ = value != null && !value.isEmpty();
            }
        });
        this.followEntityUUID.m_94144_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID) && this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID() != null ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID().toString() : "");
        this.followEntityUUIDSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.followEntityUUID.m_252754_() + this.followEntityUUID.m_5711_() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            objectiveDataEntry.setTargetEntityUUID(!this.followEntityUUID.m_94155_().isEmpty() ? UUID.fromString(this.followEntityUUID.m_94155_()) : null);
            ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
        }));
    }
}

