/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.objective.ObjectiveConfigurationScreen;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.configuration.objective.LookObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LookObjectiveConfigurationScreen
extends ObjectiveConfigurationScreen<LookObjectiveConfigurationMenu> {
    protected final OwnerData<?> ownerData;
    protected Checkbox lookResetCheckbox;
    protected Checkbox randomLookAroundCheckbox;
    protected Checkbox lookAtOwnerCheckbox;
    protected Checkbox lookAtPlayerCheckbox;
    protected Checkbox lookAtMobCheckbox;
    protected Checkbox lookAtAnimalCheckbox;
    protected Checkbox lookAtEntityCheckbox;
    protected EditBox lookAtEntityUUID;
    protected Button lookAtEntityUUIDSaveButton;

    public LookObjectiveConfigurationScreen(LookObjectiveConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.ownerData = this.easyNPC.getEasyNPCOwnerData();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.lookObjectiveButton.f_93623_ = false;
        int objectiveEntriesTop = this.contentTopPos + 5;
        this.lookResetCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop, ObjectiveType.LOOK_AT_RESET.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_RESET), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_RESET, 9);
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.randomLookAroundCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_RANDOM_AROUND.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_RANDOM_AROUND), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_RANDOM_AROUND, 10);
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtOwnerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_OWNER.getObjectiveName(), this.ownerData.getOwnerName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_OWNER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_OWNER, 9);
            objectiveDataEntry.setTargetOwnerUUID(this.ownerData.m_21805_());
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtOwnerCheckbox.f_93623_ = false;
        this.lookAtPlayerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_PLAYER.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_PLAYER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_PLAYER, 9);
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtMobCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_MOB.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_MOB), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_MOB, 10);
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtAnimalCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_ANIMAL.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ANIMAL), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_ANIMAL, 10);
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            } else {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtEntityCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 10, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_ENTITY_BY_UUID.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_ENTITY_BY_UUID, 9);
            if (this.lookAtEntityUUID != null) {
                if (!this.lookAtEntityUUID.m_94155_().isEmpty()) {
                    UUID entityUUID = null;
                    try {
                        entityUUID = UUID.fromString(this.lookAtEntityUUID.m_94155_());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to parse UUID {} for {}", (Object)this.lookAtEntityUUID.m_94155_(), (Object)this.uuid);
                    }
                    if (entityUUID != null) {
                        objectiveDataEntry.setTargetEntityUUID(entityUUID);
                    }
                }
                this.lookAtEntityUUID.m_94186_(checkbox.selected());
            }
            if (this.lookAtEntityUUIDSaveButton != null) {
                this.lookAtEntityUUIDSaveButton.f_93623_ = checkbox.selected();
            }
            if (!checkbox.selected()) {
                ServerNetworkMessageHandler.removeObjective(this.uuid, objectiveDataEntry);
            } else if (!this.lookAtEntityUUID.m_94155_().isEmpty()) {
                ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
            }
        }));
        this.lookAtEntityCheckbox.f_93623_ = false;
        this.lookAtEntityUUID = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, this.contentLeftPos + 160, objectiveEntriesTop, 115));
        this.lookAtEntityUUID.m_94199_(36);
        this.lookAtEntityUUID.m_94186_(this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID));
        this.lookAtEntityUUID.m_94151_(value -> {
            if (this.lookAtEntityUUIDSaveButton != null) {
                this.lookAtEntityUUIDSaveButton.f_93623_ = value != null && !value.isEmpty();
            }
        });
        this.lookAtEntityUUID.m_94144_(this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID) && this.objectiveDataSet.getObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID).getTargetEntityUUID() != null ? this.objectiveDataSet.getObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID).getTargetEntityUUID().toString() : "");
        this.lookAtEntityUUID.f_93623_ = false;
        this.lookAtEntityUUIDSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.lookAtEntityUUID.m_252754_() + this.lookAtEntityUUID.m_5711_() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_ENTITY_BY_UUID, 9);
            objectiveDataEntry.setTargetEntityUUID(!this.lookAtEntityUUID.m_94155_().isEmpty() ? UUID.fromString(this.lookAtEntityUUID.m_94155_()) : null);
            ServerNetworkMessageHandler.addObjective(this.uuid, objectiveDataEntry);
        }));
        this.lookAtEntityUUIDSaveButton.f_93623_ = false;
    }
}

