/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.pose.AdvancedPoseConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedPoseConfigurationScreen
extends PoseConfigurationScreen<AdvancedPoseConfigurationMenu> {
    protected SliderButton headRotationSliderButton;
    protected SliderButton bodyRotationSliderButton;
    protected SliderButton armsRotationSliderButton;
    protected SliderButton leftArmRotationSliderButton;
    protected SliderButton rightArmRotationSliderButton;
    protected SliderButton leftLegRotationSliderButton;
    protected SliderButton rightLegRotationSliderButton;

    public AdvancedPoseConfigurationScreen(AdvancedPoseConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private SliderButton createVisibilityRotationSlider(int left, int top, ModelPart modelPart, String label) {
        SliderButton sliderRotationButtonX = this.createRotationSliderCompact(left, top, modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.m_142416_((GuiEventListener)new Checkbox(sliderRotationButtonX.m_252754_() + 3, top - sliderRotationButtonX.m_93694_(), "", modelPartVisibility, checkbox -> ServerNetworkMessageHandler.modelVisibilityChange(this.uuid, modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedPoseButton.f_93623_ = false;
        int sliderLeftDefaultPos = this.contentLeftPos - 3;
        int sliderTopPos = this.contentTopPos + 16;
        int sliderLeftPos = sliderLeftDefaultPos;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 66;
        VariantData variantData = this.easyNPC.getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodyRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.armsRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.rightArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        sliderLeftPos = sliderLeftDefaultPos;
        if (this.modelData.hasRightLegModelPart()) {
            this.rightLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(this.contentLeftPos + 152, this.contentTopPos + 155, 50, (float)(this.contentLeftPos + 140) - this.xMouse, (float)(this.contentTopPos + 30) - this.yMouse, this.easyNPC);
        if (this.modelData.hasHeadModelPart() && this.headRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.head", this.headRotationSliderButton.m_252754_() + 20, this.headRotationSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodyRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.body", this.bodyRotationSliderButton.m_252754_() + 20, this.bodyRotationSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.left_arm", this.leftArmRotationSliderButton.m_252754_() + 20, this.leftArmRotationSliderButton.m_252907_() - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.arms", this.armsRotationSliderButton.m_252754_() + 20, this.armsRotationSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.right_arm", this.rightArmRotationSliderButton.m_252754_() + 20, this.rightArmRotationSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.left_leg", this.leftLegRotationSliderButton.m_252754_() + 20, this.leftLegRotationSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.right_leg", this.rightLegRotationSliderButton.m_252754_() + 5, this.rightLegRotationSliderButton.m_252907_() - 12);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.m_280509_(this.contentLeftPos + 99, this.contentTopPos, this.contentLeftPos + 206, this.contentTopPos + 188, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos + 100, this.contentTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 187, -5592406);
    }
}

