/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.menu.configuration.pose.DefaultPoseConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultPoseConfigurationScreen
extends PoseConfigurationScreen<DefaultPoseConfigurationMenu> {
    public static final int BUTTON_WIDTH = 100;
    protected Button crouchingPoseButton;
    protected Button dyingPoseButton;
    protected Button fallFlyingPoseButton;
    protected Button longJumpPoseButton;
    protected Button sleepingPoseButton;
    protected Button spinAttackPoseButton;
    protected Button standingPoseButton;
    protected Button swimmingPoseButton;

    public DefaultPoseConfigurationScreen(DefaultPoseConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void checkPoseButtonState(Pose pose, ModelPose modelPose) {
        Pose currentPose = pose != null ? pose : this.easyNPC.getEntity().m_20089_();
        boolean isCustomModelPose = (modelPose != null ? modelPose : this.modelData.getModelPose()) == ModelPose.CUSTOM;
        this.standingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.STANDING;
        this.crouchingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.CROUCHING;
        this.dyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.DYING;
        this.fallFlyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.FALL_FLYING;
        this.longJumpPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.LONG_JUMPING;
        this.sleepingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SLEEPING;
        this.spinAttackPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SPIN_ATTACK;
        this.swimmingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SWIMMING;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultPoseButton.f_93623_ = false;
        int poseButtonLeft = this.contentLeftPos + 175;
        this.standingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos, 100, "pose.standing", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.STANDING);
            this.checkPoseButtonState(Pose.STANDING, ModelPose.DEFAULT);
        }));
        this.crouchingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 24, 100, "pose.crouching", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.CROUCHING);
            this.checkPoseButtonState(Pose.CROUCHING, ModelPose.DEFAULT);
        }));
        this.dyingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 48, 100, "pose.dying", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.DYING);
            this.checkPoseButtonState(Pose.DYING, ModelPose.DEFAULT);
        }));
        this.fallFlyingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 72, 100, "pose.fall_flying", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.FALL_FLYING);
            this.checkPoseButtonState(Pose.FALL_FLYING, ModelPose.DEFAULT);
        }));
        this.longJumpPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 96, 100, "pose.long_jumping", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.LONG_JUMPING);
            this.checkPoseButtonState(Pose.LONG_JUMPING, ModelPose.DEFAULT);
        }));
        this.sleepingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 120, 100, "pose.sleeping", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.SLEEPING);
            this.checkPoseButtonState(Pose.SLEEPING, ModelPose.DEFAULT);
        }));
        this.spinAttackPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 144, 100, "pose.spin_attack", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.SPIN_ATTACK);
            this.checkPoseButtonState(Pose.SPIN_ATTACK, ModelPose.DEFAULT);
        }));
        this.swimmingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 168, 100, "pose.swimming", button -> {
            ServerNetworkMessageHandler.poseChange(this.uuid, Pose.SWIMMING);
            this.checkPoseButtonState(Pose.SWIMMING, ModelPose.DEFAULT);
        }));
        this.checkPoseButtonState(this.easyNPC.getEntity().m_20089_(), this.modelData.getModelPose());
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        boolean entityInvisible = this.easyNPC.getEntity().m_20145_();
        this.easyNPC.getEntity().m_6842_(false);
        ScreenHelper.renderScaledEntityAvatar(this.contentLeftPos + 80, this.contentTopPos + 125, 36, (float)(this.contentLeftPos + 80) - this.xMouse, (float)(this.contentTopPos + 65) - this.yMouse, this.easyNPC, this.easyNPC.getEasyNPCScaleData(), this.easyNPC.getEasyNPCModelData());
        this.easyNPC.getEntity().m_6842_(entityInvisible);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.m_280509_(this.contentLeftPos, this.contentTopPos, this.contentLeftPos + 169, this.contentTopPos + 187, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos + 1, this.contentTopPos + 1, this.contentLeftPos + 168, this.contentTopPos + 186, -5592406);
        guiGraphics.m_280509_(this.contentLeftPos + 1, this.contentTopPos + 125, this.contentLeftPos + 168, this.contentTopPos + 186, -1433892728);
        guiGraphics.m_280509_(this.contentLeftPos + 1, this.contentTopPos + 125, this.contentLeftPos + 168, this.contentTopPos + 130, -1433892728);
    }
}

