/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.skin.NoneSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class NoneSkinConfigurationScreen
extends SkinConfigurationScreen<NoneSkinConfigurationMenu> {
    protected Checkbox noneSkinCheckbox;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public NoneSkinConfigurationScreen(NoneSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.noneSkinButton.f_93623_ = false;
        SkinData skinData = this.easyNPC.getEasyNPCSkinData();
        VariantData variantData = this.easyNPC.getEasyNPCVariantData();
        SkinType formerSkinType = skinData.getSkinType();
        String formerSkinName = skinData.getSkinName();
        String formerSkinURL = skinData.getSkinURL();
        UUID formerSkinUUID = skinData.getSkinUUID();
        Enum<?> formerVariant = variantData.getVariant();
        this.noneSkinCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 100, this.f_97736_ + 170, "disable_skin_checkbox", skinData.getSkinType() == SkinType.NONE, checkbox -> {
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.setNoneSkin(this.uuid);
            } else {
                switch (formerSkinType) {
                    case DEFAULT: {
                        ServerNetworkMessageHandler.setDefaultSkin(this.uuid, formerVariant);
                        break;
                    }
                    case CUSTOM: {
                        ServerNetworkMessageHandler.setCustomSkin(this.uuid, formerSkinUUID);
                        break;
                    }
                    default: {
                        ServerNetworkMessageHandler.setDefaultSkin(this.uuid, variantData.getDefaultVariant());
                    }
                }
            }
        }));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"text.easy_npc.config.disable_skin_text"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    protected void renderSkinSelectionBackground(GuiGraphics guiGraphics) {
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.f_97735_ + 15, this.f_97736_ + 60 + line * (9 + 2));
            }
        }
    }
}

