/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationScreen;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.trading.NoneTradingConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoneTradingConfigurationScreen
extends TradingConfigurationScreen<NoneTradingConfigurationMenu> {
    private static TradingType formerTradingType = TradingType.BASIC;
    protected final TradingData<?> tradingData;
    protected Checkbox noneTradingCheckbox;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public NoneTradingConfigurationScreen(NoneTradingConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.tradingData = this.easyNPC.getEasyNPCTradingData();
    }

    public static void setFormerTradingType(TradingType dialogType) {
        formerTradingType = dialogType;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.noneTradesButton.f_93623_ = false;
        NoneTradingConfigurationScreen.setFormerTradingType(this.tradingData.getTradingType());
        this.noneTradingCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 100, this.f_97736_ + 170, "disable_trading_checkbox", this.tradingData.getTradingType() == TradingType.NONE, checkbox -> {
            if (checkbox.selected()) {
                ServerNetworkMessageHandler.changeTradingType(this.uuid, TradingType.NONE);
            } else {
                ServerNetworkMessageHandler.changeTradingType(this.uuid, formerTradingType != null && formerTradingType != TradingType.NONE ? formerTradingType : TradingType.BASIC);
            }
        }));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"text.easy_npc.config.disable_trading_text"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.f_97735_ + 15, this.f_97736_ + 60 + line * (9 + 2));
            }
        }
    }
}

