/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.spawner;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.menu.spawner.SpawnerMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SpawnerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String SPAWNER_PREFIX = "spawner.";
    private final SpawnerMenu spawnerMenu;
    private boolean updatedDataFields = false;
    private EditBox spawnerRangeEdit;
    private Button spawnerRangeSaveButton;
    private EditBox spawnerDespawnRangeEdit;
    private Button spawnerDespawnRangeSaveButton;
    private EditBox requiredPlayerRangeEdit;
    private Button requiredPlayerRangeSaveButton;
    private EditBox delayEdit;
    private Button delaySaveButton;
    private EditBox maxNearbyEntitiesEdit;
    private Button maxNearbyEntitiesSaveButton;
    private EditBox spawnCountEdit;
    private Button spawnCountSaveButton;

    protected SpawnerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.spawnerMenu = (SpawnerMenu)((Object)menu);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 260;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97731_ = this.f_97727_ - 92;
        int settingsLeft = this.f_97735_ + 196;
        int settingsTop = this.f_97736_ + 20;
        int settingsWidth = 35;
        this.requiredPlayerRangeEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop, settingsWidth, this.spawnerMenu.getRequiredPlayerRange(), 3));
        this.requiredPlayerRangeEdit.m_94151_(value -> {
            if (this.requiredPlayerRangeSaveButton != null) {
                this.requiredPlayerRangeSaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getRequiredPlayerRange();
            }
        });
        this.requiredPlayerRangeSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.requiredPlayerRangeEdit.m_252754_() + this.requiredPlayerRangeEdit.m_5711_() + 5, this.requiredPlayerRangeEdit.m_252907_() - 1, button -> {
            if (this.requiredPlayerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.REQUIRED_PLAYER_RANGE, Integer.parseInt(this.requiredPlayerRangeEdit.m_94155_()));
                this.requiredPlayerRangeSaveButton.f_93623_ = false;
            }
        }));
        this.delayEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDelay(), 4));
        this.delayEdit.m_94151_(value -> {
            if (this.delaySaveButton != null) {
                this.delaySaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDelay();
            }
        });
        this.delaySaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.delayEdit.m_252754_() + this.delayEdit.m_5711_() + 5, this.delayEdit.m_252907_() - 1, button -> {
            if (this.delayEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DELAY, Integer.parseInt(this.delayEdit.m_94155_()));
                this.delaySaveButton.f_93623_ = false;
            }
        }));
        this.maxNearbyEntitiesEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getMaxNearbyEntities(), 2));
        this.maxNearbyEntitiesEdit.m_94151_(value -> {
            if (this.maxNearbyEntitiesSaveButton != null) {
                this.maxNearbyEntitiesSaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getMaxNearbyEntities();
            }
        });
        this.maxNearbyEntitiesSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.maxNearbyEntitiesEdit.m_252754_() + this.maxNearbyEntitiesEdit.m_5711_() + 5, this.maxNearbyEntitiesEdit.m_252907_() - 1, button -> {
            if (this.maxNearbyEntitiesEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.MAX_NEARBY_ENTITIES, Integer.parseInt(this.maxNearbyEntitiesEdit.m_94155_()));
                this.maxNearbyEntitiesSaveButton.f_93623_ = false;
            }
        }));
        this.spawnCountEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnCount(), 3));
        this.spawnCountEdit.m_94151_(value -> {
            if (this.spawnCountSaveButton != null) {
                this.spawnCountSaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnCount();
            }
        });
        this.spawnCountSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.spawnCountEdit.m_252754_() + this.spawnCountEdit.m_5711_() + 5, this.spawnCountEdit.m_252907_() - 1, button -> {
            if (this.spawnCountEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_COUNT, Integer.parseInt(this.spawnCountEdit.m_94155_()));
                this.spawnCountSaveButton.f_93623_ = false;
            }
        }));
        this.spawnerRangeEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnRange(), 3));
        this.spawnerRangeEdit.m_94151_(value -> {
            if (this.spawnerRangeSaveButton != null && this.spawnerDespawnRangeEdit != null) {
                this.spawnerRangeSaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnRange() && Integer.parseInt(value) < Integer.parseInt(this.spawnerDespawnRangeEdit.m_94155_());
            }
        });
        this.spawnerRangeSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.spawnerRangeEdit.m_252754_() + this.spawnerRangeEdit.m_5711_() + 5, this.spawnerRangeEdit.m_252907_() - 1, button -> {
            if (this.spawnerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_RANGE, Integer.parseInt(this.spawnerRangeEdit.m_94155_()));
                this.spawnerRangeSaveButton.f_93623_ = false;
            }
        }));
        this.spawnerDespawnRangeEdit = (EditBox)this.m_142416_((GuiEventListener)new PositiveNumberField(this.f_96547_, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDespawnRange(), 3));
        this.spawnerDespawnRangeEdit.m_94151_(value -> {
            if (this.spawnerDespawnRangeSaveButton != null && this.spawnerRangeEdit != null) {
                this.spawnerDespawnRangeSaveButton.f_93623_ = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDespawnRange() && Integer.parseInt(value) > Integer.parseInt(this.spawnerRangeEdit.m_94155_());
            }
        });
        this.spawnerDespawnRangeSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.spawnerDespawnRangeEdit.m_252754_() + this.spawnerDespawnRangeEdit.m_5711_() + 5, this.spawnerDespawnRangeEdit.m_252907_() - 1, button -> {
            if (this.spawnerDespawnRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DESPAWN_RANGE, Integer.parseInt(this.spawnerDespawnRangeEdit.m_94155_()));
                this.spawnerDespawnRangeSaveButton.f_93623_ = false;
            }
        }));
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.updatedDataFields) {
            this.updateDataFields();
            this.updatedDataFields = true;
        }
    }

    protected void updateDataFields() {
        if (this.spawnerRangeEdit != null) {
            this.spawnerRangeEdit.m_94144_(String.valueOf(this.spawnerMenu.getSpawnRange()));
        }
        if (this.spawnerDespawnRangeEdit != null) {
            this.spawnerDespawnRangeEdit.m_94144_(String.valueOf(this.spawnerMenu.getDespawnRange()));
        }
        if (this.requiredPlayerRangeEdit != null) {
            this.requiredPlayerRangeEdit.m_94144_(String.valueOf(this.spawnerMenu.getRequiredPlayerRange()));
        }
        if (this.delayEdit != null) {
            this.delayEdit.m_94144_(String.valueOf(this.spawnerMenu.getDelay()));
        }
        if (this.maxNearbyEntitiesEdit != null) {
            this.maxNearbyEntitiesEdit.m_94144_(String.valueOf(this.spawnerMenu.getMaxNearbyEntities()));
        }
        if (this.spawnCountEdit != null) {
            this.spawnCountEdit.m_94144_(String.valueOf(this.spawnerMenu.getSpawnCount()));
        }
    }

    protected void changeSpawnerSetting(BlockPos blockPos, SpawnerSettingType spawnerSettingType, int value) {
        NetworkMessageHandlerManager.getServerHandler().changeSpawnerSettings(blockPos, spawnerSettingType, value);
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
        int labelOffsetX = -180;
        int labelOffsetY = 4;
        if (this.spawnerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_RANGE.name().toLowerCase(), this.spawnerRangeEdit.m_252754_() + labelOffsetX, this.spawnerRangeEdit.m_252907_() + labelOffsetY);
        }
        if (this.spawnerDespawnRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.DESPAWN_RANGE.name().toLowerCase(), this.spawnerDespawnRangeEdit.m_252754_() + labelOffsetX, this.spawnerDespawnRangeEdit.m_252907_() + labelOffsetY);
        }
        if (this.requiredPlayerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.REQUIRED_PLAYER_RANGE.name().toLowerCase(), this.requiredPlayerRangeEdit.m_252754_() + labelOffsetX, this.requiredPlayerRangeEdit.m_252907_() + labelOffsetY);
        }
        if (this.delayEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.DELAY.name().toLowerCase(), this.delayEdit.m_252754_() + labelOffsetX, this.delayEdit.m_252907_() + labelOffsetY);
        }
        if (this.maxNearbyEntitiesEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.MAX_NEARBY_ENTITIES.name().toLowerCase(), this.maxNearbyEntitiesEdit.m_252754_() + labelOffsetX, this.maxNearbyEntitiesEdit.m_252907_() + labelOffsetY);
        }
        if (this.spawnCountEdit != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_COUNT.name().toLowerCase(), this.spawnCountEdit.m_252754_() + labelOffsetX, this.spawnCountEdit.m_252907_() + labelOffsetY);
        }
        Text.drawConfigString(guiGraphics, this.f_96547_, "spawner.preset_item", this.f_97735_ + 42 - 20, this.f_97736_ + 169 + 22, this.spawnerMenu.getPresetItem().m_41619_() ? 0xFF5555 : 0xAAAAAA);
    }

    public void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Text.drawString(guiGraphics, this.f_96547_, this.f_96539_, this.f_97728_ + 80, this.f_97729_ + 2, 0);
        Text.drawString(guiGraphics, this.f_96547_, "(" + this.spawnerMenu.getSpawnerPosition().m_123344_() + ")", this.f_97728_ + 180, this.f_97729_ + 2, 0xAAAAAA);
        Text.drawString(guiGraphics, this.f_96547_, this.f_169604_, this.f_97730_ + 90, this.f_97731_ - 10, 0);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderLabels(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_ + 153, this.f_97736_, 132, 0, 120, 160);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_ + 153, this.f_97736_ + 77, 132, 5, 120, 170);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 97, this.f_97736_ + 152, 7, 83, 162, 54);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 97, this.f_97736_ + 212, 7, 141, 162, 18);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 42 - 1, this.f_97736_ + 169 - 1, 76, 61, 18, 18);
        if (this.spawnerMenu.getPresetItem().m_41619_()) {
            guiGraphics.m_280218_(Constants.TEXTURE_SPAWNER, this.f_97735_ + 42 + 20, this.f_97736_ + 169 + 2, 0, 0, 32, 12);
            guiGraphics.m_280218_(Constants.TEXTURE_SPAWNER, this.f_97735_ + 42 + 1, this.f_97736_ + 169, 2, 12, 16, 16);
        }
    }
}

