/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final int RELOAD_PROTECTION = 10000;
    private static final HashMap<TextureModelKey, ResourceLocation> textureCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static int reloadProtectionCounter = 0;

    private CustomTextureManager() {
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel())) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static ResourceLocation getOrCreateTextureWithDefault(SkinData<?> skinData, ResourceLocation defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        ResourceLocation resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            return resourceLocation;
        }
        ResourceLocation createdResourceLocation = CustomTextureManager.createTexture(textureModelKey, skinData);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinData<?> skinData) {
        UUID skinUUID = textureModelKey.getUUID();
        if (!textureReloadProtection.add(skinUUID)) {
            if (reloadProtectionCounter++ > 10000) {
                textureReloadProtection.clear();
                reloadProtectionCounter = 0;
            }
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        ResourceLocation localTextureCache = TextureManager.searchCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            return localTextureCache;
        }
        log.error("Unable to load custom texture {} from {}!", (Object)textureModelKey, (Object)textureDataFolder);
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        CustomTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }

    public static void clearTextureCache() {
        textureReloadProtection.clear();
        textureCache.clear();
    }
}

