/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface RenderData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_RENDER_DATA_TAG = "RenderData";
    public static final EntityDataSerializer<RenderDataSet> RENDER_DATA_SET = new EntityDataSerializer<RenderDataSet>(){

        public void write(FriendlyByteBuf buffer, RenderDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public RenderDataSet read(FriendlyByteBuf buffer) {
            return new RenderDataSet(buffer.m_130260_());
        }

        public RenderDataSet copy(RenderDataSet value) {
            return value;
        }
    };

    public static void registerRenderDataSerializer() {
        EntityDataSerializers.m_135050_(RENDER_DATA_SET);
    }

    public static void registerSyncedRenderData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Render Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.RENDER_DATA, SynchedEntityData.m_135353_(entityClass, RENDER_DATA_SET));
    }

    default public void defineSynchedRenderData() {
        this.defineSynchedEntityData(SynchedDataIndex.RENDER_DATA, new RenderDataSet());
    }

    default public RenderDataSet getRenderData() {
        return (RenderDataSet)this.getSynchedEntityData(SynchedDataIndex.RENDER_DATA);
    }

    default public void setRenderData(RenderDataSet renderData) {
        this.setSynchedEntityData(SynchedDataIndex.RENDER_DATA, renderData);
    }

    default public void updateRenderData() {
        RenderDataSet renderData = this.getRenderData();
        this.setRenderData(new RenderDataSet());
        this.setRenderData(renderData);
    }

    default public void addAdditionalRenderData(CompoundTag compoundTag) {
        CompoundTag renderTag = new CompoundTag();
        RenderDataSet renderData = this.getRenderData();
        if (renderData != null) {
            renderData.save(renderTag);
        }
        compoundTag.m_128365_(DATA_RENDER_DATA_TAG, (Tag)renderTag);
    }

    default public void readAdditionalRenderData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_RENDER_DATA_TAG)) {
            return;
        }
        RenderDataSet renderData = new RenderDataSet(compoundTag.m_128469_(DATA_RENDER_DATA_TAG));
        this.setRenderData(renderData);
    }
}

