/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface SkinData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final EntityDataSerializer<SkinType> SKIN_TYPE = new EntityDataSerializer<SkinType>(){

        public void write(FriendlyByteBuf buffer, SkinType skinType) {
            buffer.m_130068_((Enum)skinType);
        }

        public SkinType read(FriendlyByteBuf buffer) {
            return (SkinType)buffer.m_130066_(SkinType.class);
        }

        public SkinType copy(SkinType skinType) {
            return skinType;
        }
    };
    public static final EntityDataSerializer<UUID> SKIN_UUID = new EntityDataSerializer<UUID>(){

        public void write(FriendlyByteBuf buffer, UUID skinUUID) {
            buffer.m_130077_(skinUUID);
        }

        public UUID read(FriendlyByteBuf buffer) {
            return buffer.m_130259_();
        }

        public UUID copy(UUID skinUUID) {
            return skinUUID;
        }
    };
    public static final String EASY_NPC_DATA_SKIN_DATA_TAG = "SkinData";
    public static final String EASY_NPC_DATA_SKIN_NAME_TAG = "SkinName";
    public static final String EASY_NPC_DATA_SKIN_TAG = "Skin";
    public static final String EASY_NPC_DATA_SKIN_TYPE_TAG = "SkinType";
    public static final String EASY_NPC_DATA_SKIN_URL_TAG = "SkinURL";
    public static final String EASY_NPC_DATA_SKIN_UUID_TAG = "SkinUUID";

    public static void registerSyncedSkinData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Skin Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SKIN_NAME, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135030_));
        map.put(SynchedDataIndex.SKIN_URL, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135030_));
        map.put(SynchedDataIndex.SKIN_UUID, SynchedEntityData.m_135353_(entityClass, SKIN_UUID));
        map.put(SynchedDataIndex.SKIN_TYPE, SynchedEntityData.m_135353_(entityClass, SKIN_TYPE));
    }

    public static void registerSkinDataSerializer() {
        EntityDataSerializers.m_135050_(SKIN_TYPE);
        EntityDataSerializers.m_135050_(SKIN_UUID);
    }

    default public int getEntitySkinScaling() {
        return 30;
    }

    default public String getSkinName() {
        return (String)this.getSynchedEntityData(SynchedDataIndex.SKIN_NAME);
    }

    default public void setSkinName(String skin) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_NAME, skin != null ? skin : "");
    }

    default public String getSkinURL() {
        return (String)this.getSynchedEntityData(SynchedDataIndex.SKIN_URL);
    }

    default public void setSkinURL(String skinURL) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_URL, skinURL != null ? skinURL : "");
    }

    default public UUID getSkinUUID() {
        return (UUID)this.getSynchedEntityData(SynchedDataIndex.SKIN_UUID);
    }

    default public void setSkinUUID(UUID uuid) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_UUID, uuid != null ? uuid : Constants.BLANK_UUID);
    }

    default public SkinType getSkinType() {
        return (SkinType)((Object)this.getSynchedEntityData(SynchedDataIndex.SKIN_TYPE));
    }

    default public void setSkinType(SkinType skinType) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_TYPE, skinType);
    }

    default public SkinType getSkinType(String name) {
        return SkinType.get(name);
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public void defineSynchedSkinData() {
        this.defineSynchedEntityData(SynchedDataIndex.SKIN_NAME, "");
        this.defineSynchedEntityData(SynchedDataIndex.SKIN_URL, "");
        this.defineSynchedEntityData(SynchedDataIndex.SKIN_UUID, Constants.BLANK_UUID);
        this.defineSynchedEntityData(SynchedDataIndex.SKIN_TYPE, SkinType.DEFAULT);
    }

    default public void addAdditionalSkinData(CompoundTag compoundTag) {
        UUID skinUUID;
        CompoundTag skinTag = new CompoundTag();
        if (this.getSkinName() != null) {
            skinTag.m_128359_(EASY_NPC_DATA_SKIN_TAG, this.getSkinName());
        }
        if (this.getSkinURL() != null) {
            skinTag.m_128359_(EASY_NPC_DATA_SKIN_URL_TAG, this.getSkinURL());
        }
        if ((skinUUID = this.getSkinUUID()) != null && !skinUUID.equals(Constants.BLANK_UUID)) {
            skinTag.m_128362_(EASY_NPC_DATA_SKIN_UUID_TAG, skinUUID);
        }
        if (this.getSkinType() != null) {
            skinTag.m_128359_(EASY_NPC_DATA_SKIN_TYPE_TAG, this.getSkinType().name());
        }
        compoundTag.m_128365_(EASY_NPC_DATA_SKIN_DATA_TAG, (Tag)skinTag);
    }

    default public void readAdditionalSkinData(CompoundTag compoundTag) {
        String url;
        String skinName;
        String skinType;
        if (!compoundTag.m_128441_(EASY_NPC_DATA_SKIN_DATA_TAG)) {
            return;
        }
        CompoundTag skinTag = compoundTag.m_128469_(EASY_NPC_DATA_SKIN_DATA_TAG);
        if (skinTag.m_128441_(EASY_NPC_DATA_SKIN_TYPE_TAG) && !(skinType = skinTag.m_128461_(EASY_NPC_DATA_SKIN_TYPE_TAG)).isEmpty()) {
            this.setSkinType(this.getSkinType(skinType));
        }
        if (skinTag.m_128441_(EASY_NPC_DATA_SKIN_NAME_TAG) && !(skinName = skinTag.m_128461_(EASY_NPC_DATA_SKIN_NAME_TAG)).isEmpty()) {
            this.setSkinName(skinName);
        }
        if (skinTag.m_128441_(EASY_NPC_DATA_SKIN_URL_TAG) && !(url = skinTag.m_128461_(EASY_NPC_DATA_SKIN_URL_TAG)).isEmpty()) {
            this.setSkinURL(url);
        }
        if (skinTag.m_128441_(EASY_NPC_DATA_SKIN_UUID_TAG)) {
            UUID skinUUID = skinTag.m_128342_(EASY_NPC_DATA_SKIN_UUID_TAG);
            this.setSkinUUID(skinUUID);
        }
    }
}

