/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InteractionHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private InteractionHandler() {
    }

    public static InteractionResult handleMobInteraction(EasyNPC<?> easyNPC, Player player, InteractionHand hand) {
        DialogData<?> dialogData;
        ServerPlayer serverPlayer;
        block14: {
            block13: {
                if (!(player instanceof ServerPlayer)) break block13;
                serverPlayer = (ServerPlayer)player;
                if (hand == InteractionHand.MAIN_HAND) break block14;
            }
            return InteractionResult.PASS;
        }
        ConfigurationData<?> configurationData = easyNPC.getEasyNPCConfigurationData();
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        boolean isOwnerOrCreative = serverPlayer.m_7500_() || ownerData.isOwner(serverPlayer);
        ItemStack handItemStack = player.m_21120_(hand);
        if (!handItemStack.m_41619_()) {
            Item easyNPCWand;
            Item handItem = handItemStack.m_41720_();
            if (handItem.equals(easyNPCWand = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("easy_npc", "easy_npc_wand")).orElse(null))) {
                configurationData.openMainConfigurationMenu(serverPlayer);
                return InteractionResult.PASS;
            }
            if ("armourers_workshop".equals(BuiltInRegistries.f_257033_.m_7981_((Object)handItem).m_135827_())) {
                if (isOwnerOrCreative) {
                    SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
                    if (skinData.getSkinModel().hasArmourersWorkshopSupport()) {
                        log.debug("Ignore event for Armourer's Workshop Item for {} ...", easyNPC);
                        return InteractionResult.PASS;
                    }
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"text.easy_npc.armourers_workshop.no_support", (Object[])new Object[]{skinData.getSkinModel().name(), easyNPC}));
                } else {
                    log.debug("{} has no permissions to use Armourer's Workshop Item for {} ...", (Object)serverPlayer, easyNPC);
                    return InteractionResult.CONSUME;
                }
            }
        }
        if (player.m_7500_() && player.m_6047_()) {
            configurationData.openMainConfigurationMenu(serverPlayer);
            return InteractionResult.PASS;
        }
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.handleActionInteractionEvent(serverPlayer);
        }
        if ((dialogData = easyNPC.getEasyNPCDialogData()) != null && dialogData.hasDialog()) {
            dialogData.openDialog(serverPlayer);
            return InteractionResult.CONSUME;
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null && tradingData.hasTrading()) {
            return tradingData.openTradingScreen(serverPlayer);
        }
        return InteractionResult.PASS;
    }
}

