/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration.equipment;

import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.equipment.ArmorSlot;
import de.markusbordihn.easynpc.menu.configuration.equipment.HandSlot;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EquipmentConfigurationMenu
extends ConfigurationMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final int ARMOR_CONTAINER_SIZE = 4;
    protected static final int HAND_CONTAINER_SIZE = 2;
    protected static final int SLOT_SIZE = 18;
    protected final Container armorContainer;
    protected final Container handContainer;

    public EquipmentConfigurationMenu(int windowId, Inventory playerInventory, UUID uuid) {
        this((MenuType)ModMenuTypes.EQUIPMENT_CONFIGURATION_MENU.get(), windowId, playerInventory, uuid);
    }

    public EquipmentConfigurationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_());
    }

    public EquipmentConfigurationMenu(MenuType<?> menuType, int windowId, Inventory inventory, UUID uuid) {
        this(menuType, windowId, inventory, (Container)new SimpleContainer(4), (Container)new SimpleContainer(2), uuid);
    }

    public EquipmentConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, Container armorContainer, Container handContainer, UUID uuid) {
        super(menuType, windowId, playerInventory, uuid);
        EquipmentConfigurationMenu.m_38869_((Container)armorContainer, (int)4);
        EquipmentConfigurationMenu.m_38869_((Container)handContainer, (int)2);
        this.armorContainer = armorContainer;
        this.handContainer = handContainer;
        this.loadHand();
        ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
        if (modelData == null || modelData.canUseArmor()) {
            this.loadArmor();
            int playerCompanionEquipmentLeftStartPositionY = 44;
            int playerCompanionEquipmentLeftStartPositionX = 98;
            for (int armorSlot = 3; armorSlot >= 0; --armorSlot) {
                this.m_38897_(new ArmorSlot(this, this.armorContainer, 3 - armorSlot, playerCompanionEquipmentLeftStartPositionX, playerCompanionEquipmentLeftStartPositionY + armorSlot * 18));
            }
        }
        if (modelData == null || modelData.canUseMainHand()) {
            int playerCompanionMainHandStartPositionY = 119;
            int playerCompanionMainHandStartPositionX = 98;
            this.m_38897_(new HandSlot(this, this.handContainer, EquipmentSlot.MAINHAND.m_20749_(), playerCompanionMainHandStartPositionX, playerCompanionMainHandStartPositionY));
        }
        if (modelData == null || modelData.canUseOffHand()) {
            int playerCompanionOffHandStartPositionY = 119;
            int playerCompanionOffHandStartPositionX = 178;
            this.m_38897_(new HandSlot(this, this.handContainer, EquipmentSlot.OFFHAND.m_20749_(), playerCompanionOffHandStartPositionX, playerCompanionOffHandStartPositionY));
        }
        int playerInventoryStartPositionY = 149;
        int playerInventoryStartPositionX = 66;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 209;
        int hotbarStartPositionX = 66;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
    }

    public static MenuProvider getMenuProvider(final UUID uuid, final Entity entity) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)("Equipment for " + entity.m_7755_().getString()));
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                return new EquipmentConfigurationMenu(windowId, inventory, uuid);
            }
        };
    }

    public void loadHand() {
        if (this.level.f_46443_) {
            return;
        }
        log.debug("Load hand {}", (Object)this.getEasyNPC().getLivingEntity().m_6167_());
        this.handContainer.m_6836_(0, this.getEasyNPC().getLivingEntity().m_21120_(InteractionHand.MAIN_HAND));
        this.handContainer.m_6836_(1, this.getEasyNPC().getLivingEntity().m_21120_(InteractionHand.OFF_HAND));
        this.handContainer.m_6596_();
    }

    public void setHandChanged(InteractionHand hand, ItemStack itemStack) {
        if (this.level.f_46443_) {
            return;
        }
        log.debug("Hand changed {} {} ...", (Object)hand, (Object)itemStack);
        this.getEasyNPC().getLivingEntity().m_21008_(hand, itemStack);
    }

    public void loadArmor() {
        if (this.level.f_46443_) {
            return;
        }
        log.debug("Load armor {}", (Object)this.getEasyNPC().getLivingEntity().m_6168_());
        this.armorContainer.m_6836_(0, this.getEasyNPC().getLivingEntity().m_6844_(EquipmentSlot.FEET));
        this.armorContainer.m_6836_(1, this.getEasyNPC().getLivingEntity().m_6844_(EquipmentSlot.LEGS));
        this.armorContainer.m_6836_(2, this.getEasyNPC().getLivingEntity().m_6844_(EquipmentSlot.CHEST));
        this.armorContainer.m_6836_(3, this.getEasyNPC().getLivingEntity().m_6844_(EquipmentSlot.HEAD));
        this.armorContainer.m_6596_();
    }

    public void setArmorChanged(EquipmentSlot equipmentSlot, int slot, ItemStack itemStack) {
        if (this.level.f_46443_) {
            return;
        }
        log.debug("Armor changed {} {} {} ...", (Object)equipmentSlot, (Object)slot, (Object)itemStack);
        this.getEasyNPC().getLivingEntity().m_8061_(equipmentSlot, itemStack);
    }
}

