/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.dialog;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final ActionEventSet actionDataSet;
    protected final DialogDataSet dialogDataSet;
    protected final Inventory playerInventory;
    protected final EasyNPC<?> easyNPC;
    protected final UUID dialogId;
    protected final UUID uuid;
    protected final int pageIndex;

    public DialogMenu(int windowId, Inventory playerInventory, UUID uuid, ActionEventSet actionsDataSet, DialogDataSet dialogDataSet, UUID dialogId, int pageIndex) {
        this((MenuType)ModMenuTypes.DIALOG_MENU.get(), windowId, playerInventory, uuid, actionsDataSet, dialogDataSet, dialogId, pageIndex);
    }

    public DialogMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_(), new ActionEventSet(data.m_130260_()), new DialogDataSet(data.m_130260_()), data.m_130259_(), data.readInt());
    }

    public DialogMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, UUID uuid, ActionEventSet actionDataSet, DialogDataSet dialogDataSet, UUID dialogId, int pageIndex) {
        super(menuType, windowId);
        this.playerInventory = playerInventory;
        this.actionDataSet = actionDataSet;
        this.dialogDataSet = dialogDataSet;
        this.uuid = uuid;
        this.dialogId = dialogId;
        this.pageIndex = pageIndex;
        this.easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid);
        log.debug("Open Dialog menu for {}: {} with player inventory {} and actions {} and dialogs {}", (Object)this.uuid, this.easyNPC, (Object)playerInventory, (Object)this.actionDataSet, (Object)this.dialogDataSet);
    }

    public static MenuProvider getMenuProvider(final UUID uuid, final Entity entity, final ActionEventSet actionDataSet, final DialogDataSet dialogDataSet, final UUID dialogId, final int pageIndex) {
        return new MenuProvider(){

            public Component m_5446_() {
                return entity.m_7755_();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                return new DialogMenu(windowId, inventory, uuid, actionDataSet, dialogDataSet, dialogId, pageIndex);
            }
        };
    }

    public ActionEventSet getActionEventSet() {
        return this.actionDataSet;
    }

    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    public EasyNPC<?> getEasyNPC() {
        return this.easyNPC;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public boolean m_6875_(Player player) {
        return player != null && player.m_6084_() && this.easyNPC != null && this.easyNPC.getEntity().m_6084_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }
}

