/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageNameChange
extends NetworkMessage {
    protected final String name;
    protected final int color;

    public MessageNameChange(UUID uuid, String name, int color) {
        super(uuid);
        this.name = name;
        this.color = color;
    }

    public static MessageNameChange decode(FriendlyByteBuf buffer) {
        return new MessageNameChange(buffer.m_130259_(), buffer.m_130277_(), buffer.readInt());
    }

    public static void encode(MessageNameChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getName());
        buffer.writeInt(message.color);
    }

    public static void handle(MessageNameChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageNameChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageNameChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.error("Invalid name {} for {} from {}", (Object)name, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Invalid EasyNPC {} for {} from {}", easyNPC, (Object)message, (Object)serverPlayer);
            return;
        }
        int color = message.getColor();
        log.debug("Change name {} for {} from {} with color {}", (Object)name, easyNPC, (Object)serverPlayer, (Object)color);
        if (color >= 0) {
            Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
            easyNPC.getEntity().m_6593_((Component)Component.m_237113_((String)name).m_6270_(style));
        } else {
            easyNPC.getEntity().m_6593_((Component)Component.m_237113_((String)name));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }
}

