/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenConfiguration
extends NetworkMessage {
    protected final ConfigurationType configurationType;
    protected final int pageIndex;

    public MessageOpenConfiguration(UUID uuid, ConfigurationType configurationType, int pageIndex) {
        super(uuid);
        this.configurationType = configurationType;
        this.pageIndex = pageIndex;
    }

    public static MessageOpenConfiguration decode(FriendlyByteBuf buffer) {
        return new MessageOpenConfiguration(buffer.m_130259_(), (ConfigurationType)buffer.m_130066_(ConfigurationType.class), buffer.readInt());
    }

    public static void encode(MessageOpenConfiguration message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getConfigurationType());
        buffer.writeInt(message.pageIndex);
    }

    public static void handle(MessageOpenConfiguration message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageOpenConfiguration.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageOpenConfiguration message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ConfigurationType configurationType = message.getConfigurationType();
        if (configurationType == null) {
            log.error("Invalid configuration type {} for {} from {}", (Object)configurationType, (Object)message, (Object)serverPlayer);
            return;
        }
        int pageIndex = message.getPageIndex();
        if (pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)pageIndex, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        MenuManager.getMenuHandler().openConfigurationMenu(configurationType, serverPlayer, easyNPC, pageIndex);
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }
}

