/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenDialogEditor
extends NetworkMessage {
    protected final UUID dialogId;
    protected final ConfigurationType formerConfigurationType;
    protected final int pageIndex;

    public MessageOpenDialogEditor(UUID uuid, UUID dialogId, ConfigurationType formerConfigurationType) {
        this(uuid, dialogId, formerConfigurationType, 0);
    }

    public MessageOpenDialogEditor(UUID uuid, UUID dialogId, ConfigurationType formerConfigurationType, int pageIndex) {
        super(uuid);
        this.dialogId = dialogId;
        this.pageIndex = pageIndex;
        this.formerConfigurationType = formerConfigurationType;
    }

    public static MessageOpenDialogEditor decode(FriendlyByteBuf buffer) {
        return new MessageOpenDialogEditor(buffer.m_130259_(), buffer.m_130259_(), (ConfigurationType)buffer.m_130066_(ConfigurationType.class), buffer.readInt());
    }

    public static void encode(MessageOpenDialogEditor message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.dialogId);
        buffer.m_130068_((Enum)message.formerConfigurationType);
        buffer.writeInt(message.pageIndex);
    }

    public static void handle(MessageOpenDialogEditor message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageOpenDialogEditor.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageOpenDialogEditor message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id {} for {} from {}", (Object)dialogId, (Object)message, (Object)context);
            return;
        }
        int pageIndex = message.getPageIndex();
        if (pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)pageIndex, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        if (dialogId.equals(EMPTY_UUID)) {
            String dialogName = dialogData.getDialogDataSet().hasDialog() ? "Dialog " + RANDOM.nextInt(1000) : "Default";
            DialogDataEntry newDialogData = new DialogDataEntry(dialogName);
            log.info("Create new dialog {} for {} from {}", (Object)newDialogData, (Object)uuid, (Object)serverPlayer);
            dialogData.getDialogDataSet().addDialog(newDialogData);
            dialogId = newDialogData.getId();
        } else if (!dialogData.hasDialog(dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", (Object)uuid, (Object)dialogData.getDialogDataSet());
            return;
        }
        ConfigurationType formerConfigurationType = message.getFormerConfigurationType();
        log.info("Open dialog editor with ref: {} for dialog {} for {} from {}", (Object)formerConfigurationType, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
        MenuManager.getMenuHandler().openDialogEditorMenu(serverPlayer, easyNPC, dialogId, formerConfigurationType, pageIndex);
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public ConfigurationType getFormerConfigurationType() {
        return this.formerConfigurationType;
    }
}

