/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageSaveDialogSet
extends NetworkMessage {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final DialogDataSet dialogDataSet;

    public MessageSaveDialogSet(UUID uuid, DialogDataSet dialogDataSet) {
        super(uuid);
        this.dialogDataSet = dialogDataSet;
    }

    public static MessageSaveDialogSet decode(FriendlyByteBuf buffer) {
        return new MessageSaveDialogSet(buffer.m_130259_(), new DialogDataSet(buffer.m_130260_()));
    }

    public static void encode(MessageSaveDialogSet message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130079_(message.getDialogData().createTag());
    }

    public static void handle(MessageSaveDialogSet message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSaveDialogSet.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSaveDialogSet message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        DialogDataSet dialogDataSet = message.getDialogData();
        if (serverPlayer == null || dialogDataSet == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to save dialog with message {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        log.debug("Saving dialog {} for {} from {}", (Object)dialogDataSet, easyNPC, (Object)serverPlayer);
        dialogData.setDialogDataSet(dialogDataSet);
    }

    public DialogDataSet getDialogData() {
        return this.dialogDataSet;
    }
}

