/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenHelper {
    protected ScreenHelper() {
    }

    public static void renderEntity(int x, int y, int scale, float yRot, float xRot, LivingEntity livingEntity) {
        Minecraft minecraft = Minecraft.m_91087_();
        float f = (float)Math.atan(yRot / 40.0f);
        float f1 = (float)Math.atan(xRot / 40.0f);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack1 = new PoseStack();
        poseStack1.m_85837_(0.0, 0.0, 1000.0);
        poseStack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        poseStack1.m_252781_(quaternionf);
        Component entityCustomName = livingEntity.m_7770_();
        boolean entityShouldShowName = livingEntity.m_6052_();
        float entityXRot = livingEntity.m_146909_();
        float entityYBodyRot = livingEntity.f_20883_;
        float entityYHeadRot = livingEntity.f_20885_;
        float entityYHeadRotO = livingEntity.f_20886_;
        float entityYRot = livingEntity.m_146908_();
        livingEntity.f_20883_ = 180.0f + f * 20.0f;
        livingEntity.m_146922_(180.0f + f * 40.0f);
        livingEntity.m_146926_(-f1 * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.f_91066_.f_92062_;
            minecraft.f_91066_.f_92062_ = true;
        } else {
            livingEntity.m_6593_(null);
            livingEntity.m_20340_(false);
        }
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternionf1.conjugate();
        entityRenderDispatcher.m_252923_(quaternionf1);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack1, (MultiBufferSource)multiBuffer, 0xF000F0);
        multiBuffer.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.f_20883_ = entityYBodyRot;
        livingEntity.m_146922_(entityYRot);
        livingEntity.m_146926_(entityXRot);
        livingEntity.f_20885_ = entityYHeadRot;
        livingEntity.f_20886_ = entityYHeadRotO;
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = minecraftHideGui;
        } else {
            livingEntity.m_6593_(entityCustomName);
            livingEntity.m_20340_(entityShouldShowName);
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public static void renderScaledEntityAvatar(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (scaleData != null && modelData != null) {
            ScreenHelper.renderScaledEntityAvatar(x, y, guiData.getEntityGuiScaling(), yRot, xRot, easyNPC, scaleData, modelData);
        } else {
            ScreenHelper.renderScaledEntityAvatar(x, y, guiData.getEntityGuiScaling(), yRot, xRot, easyNPC.getLivingEntity());
        }
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, ScaleData<?> scaleData, ModelData<?> modelData) {
        float entityScaleX = scaleData.getScaleX().floatValue();
        float entityScaleY = scaleData.getScaleY().floatValue();
        float entityScaleZ = scaleData.getScaleZ().floatValue();
        CustomRotation entityModelRootRotation = modelData.getModelRootRotation();
        boolean entityInvisible = easyNPC.getEntity().m_20145_();
        scaleData.setScaleX(scaleData.getDefaultScaleX());
        scaleData.setScaleY(scaleData.getDefaultScaleY());
        scaleData.setScaleZ(scaleData.getDefaultScaleZ());
        modelData.setModelRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f));
        easyNPC.getEntity().m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        scaleData.setScaleX(Float.valueOf(entityScaleX));
        scaleData.setScaleY(Float.valueOf(entityScaleY));
        scaleData.setScaleZ(Float.valueOf(entityScaleZ));
        modelData.setModelRootRotation(entityModelRootRotation);
        easyNPC.getEntity().m_6842_(entityInvisible);
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, LivingEntity livingEntity) {
        boolean entityInvisible = livingEntity.m_20145_();
        livingEntity.m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, livingEntity);
        livingEntity.m_6842_(entityInvisible);
    }

    public static void renderCustomPoseEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        ModelPose entityModelPose = modelData.getModelPose();
        Pose entityPose = easyNPC.getEntity().m_20089_();
        modelData.setModelPose(ModelPose.CUSTOM);
        entity.m_20124_(Pose.STANDING);
        ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, easyNPC, easyNPC.getEasyNPCScaleData(), modelData);
        modelData.setModelPose(entityModelPose);
        entity.m_20124_(entityPose);
    }

    public static void renderEntityAvatarForScaling(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        CustomRotation entityModelRootRotation = modelData.getModelRootRotation();
        boolean entityInvisible = entity.m_20145_();
        modelData.setModelRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f));
        entity.m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelRootRotation(entityModelRootRotation);
        entity.m_6842_(entityInvisible);
    }

    public static void renderEntityDialog(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        ScreenHelper.renderScaledEntityAvatar(x, y, dialogData.getEntityDialogScaling(), yRot, xRot, easyNPC.getLivingEntity());
    }

    public static void renderEntityPlayerSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, UUID userUUID, SkinType skinType) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        UUID entitySkinUUID = skinData.getSkinUUID();
        skinData.setSkinType(skinType);
        skinData.setSkinUUID(userUUID);
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC, easyNPC.getEasyNPCScaleData(), easyNPC.getEasyNPCModelData());
        skinData.setSkinType(entitySkinType);
        skinData.setSkinUUID(entitySkinUUID);
    }

    public static void renderEntityDefaultSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, Enum<?> variant, Profession profession) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        VariantData<?> variantData = easyNPC.getEasyNPCVariantData();
        ProfessionData<?> professionData = easyNPC.getEasyNPCProfessionData();
        GuiData<?> guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        Enum<?> entityVariant = variantData.getVariant();
        Profession entityProfession = professionData.getProfession();
        skinData.setSkinType(SkinType.DEFAULT);
        variantData.setVariant(variant);
        professionData.setProfession(profession);
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC.getLivingEntity());
        skinData.setSkinType(entitySkinType);
        variantData.setVariant(entityVariant);
        professionData.setProfession(entityProfession);
    }
}

