/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class DeleteCommand
extends Command {
    private DeleteCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"delete").requires(cs -> cs.m_6761_(0))).then(Commands.m_82129_((String)"targets", (ArgumentType)new EasyNPCArgument()).executes(context -> DeleteCommand.delete((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<CommandSourceStack>)context, "targets"))));
    }

    private static int delete(CommandSourceStack context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int deletedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                easyNPC.getEntity().m_146870_();
                ++deletedEntities;
                continue;
            }
            DeleteCommand.sendFailureMessage(context, "You are not allowed to delete the Easy NPC " + uuid + " !");
        }
        if (deletedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return DeleteCommand.sendSuccessMessage(context, "Deleted Easy NPC " + easyNPC.getEntity().m_5446_().getString() + " !");
        }
        if (deletedEntities > 1) {
            return DeleteCommand.sendSuccessMessage(context, "Deleted " + deletedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return DeleteCommand.sendFailureMessage(context, "Nothing to delete!");
    }
}

