/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class DialogCommand
extends Command {
    private DialogCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dialog").requires(cs -> cs.m_6761_(2))).executes(DialogCommand::openDialog)).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"target", (ArgumentType)new EasyNPCArgument()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(DialogCommand::openDialog)).then(Commands.m_82129_((String)"dialog", (ArgumentType)StringArgumentType.string()).executes(DialogCommand::openDialog)))));
    }

    public static int openDialog(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer serverPlayer;
        CommandSourceStack commandSource = (CommandSourceStack)context.getSource();
        try {
            serverPlayer = EntityArgument.m_91474_(context, (String)"player");
        }
        catch (Exception e) {
            return DialogCommand.sendFailureMessage(commandSource, "Failed to get player from context: " + e.getMessage());
        }
        String dialogLabel = "";
        try {
            dialogLabel = StringArgumentType.getString(context, (String)"dialog");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!serverPlayer.m_6084_()) {
            return DialogCommand.sendFailureMessage(commandSource, "Player is death!");
        }
        EasyNPC<?> easyNPC = EasyNPCArgument.getEntity(context, "target");
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog()) {
            return DialogCommand.sendFailureMessage(commandSource, "Found no Dialog data for EasyNPC with UUID " + easyNPC.getUUID() + " !");
        }
        if (!dialogLabel.isEmpty() && !easyNPC.getEasyNPCDialogData().hasDialog(dialogLabel)) {
            return DialogCommand.sendFailureMessage(commandSource, "Found no Dialog with label " + dialogLabel + " for EasyNPC with UUID " + easyNPC.getUUID() + "!");
        }
        easyNPC.getEasyNPCDialogData().openDialog(serverPlayer, dialogLabel);
        return DialogCommand.sendSuccessMessage(commandSource, "\u25ba Open dialog for " + easyNPC + " with " + serverPlayer + " and dialog " + dialogLabel, ChatFormatting.GREEN);
    }
}

