/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.Entity;

public class BaseColorableAgeableListModel<E extends Entity>
extends ColorableAgeableListModel<E>
implements EasyNPCModel<E> {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, Rotations> modelPartRotationMap = new EnumMap<ModelPartType, Rotations>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    protected final ModelPart tail;
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;

    public BaseColorableAgeableListModel(ModelPart modelPart) {
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.rightHindLeg = this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.leftHindLeg = this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.rightFrontLeg = this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.leftFrontLeg = this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.tail = this.defineModelPart(ModelPartType.TAIL, modelPart, "tail");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.TAIL, this.tail);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg, this.tail);
    }

    public void m_6973_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.f_104203_ = headPitch * ((float)Math.PI / 180);
        headPart.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.modelPartPositionMap.put(modelPartType, customPosition);
    }

    @Override
    public void setDefaultModelPartRotation(ModelPartType modelPartType, Rotations rotations) {
        this.modelPartRotationMap.put(modelPartType, rotations);
    }

    @Override
    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    @Override
    public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.modelPartPositionMap.getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    @Override
    public Rotations getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.modelPartRotationMap.getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    @Override
    public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.getOrDefault((Object)modelPartType, null);
    }

    @Override
    public boolean isHumanoidModel() {
        return false;
    }
}

