/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.client.model.standard.StandardZombieModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.OuterLayer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Zombie;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class ZombieModelRenderer
extends BaseHumanoidMobModelRenderer<Zombie, Zombie.Variant, StandardZombieModel<Zombie>> {
    protected static final Map<Zombie.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Zombie.Variant.class), map -> {
        map.put(Zombie.Variant.DROWNED, new ResourceLocation("textures/entity/zombie/drowned.png"));
        map.put(Zombie.Variant.HUSK, new ResourceLocation("textures/entity/zombie/husk.png"));
        map.put(Zombie.Variant.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
    });
    protected static final Map<Zombie.Variant, ResourceLocation> OUTER_TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Zombie.Variant.class), map -> map.put(Zombie.Variant.DROWNED, new ResourceLocation("textures/entity/zombie/drowned_outer_layer.png")));
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Zombie.Variant.ZOMBIE);

    public <T extends RenderLayer<Zombie, StandardZombieModel<Zombie>>> ZombieModelRenderer(EntityRendererProvider.Context context, Class<T> humanoidArmorLayerClass) {
        super(context, new StandardZombieModel(context.m_174023_(ModelLayers.f_171223_)), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.m_115326_((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.f_171226_, ModelLayers.f_171227_, humanoidArmorLayerClass));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_(new OuterLayer(this, context.m_174027_(), OUTER_TEXTURE_BY_VARIANT));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
    }

    @Override
    public void renderDefaultPose(Zombie entity, StandardZombieModel<Zombie> playerModel, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-1.0, 0.0, 0.0);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                playerModel.m_5585_().f_104203_ = -0.7853982f;
                playerModel.m_5585_().f_104204_ = -0.7853982f;
                playerModel.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                playerModel.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                playerModel.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                playerModel.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                playerModel.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-35.0f));
                break;
            }
            default: {
                playerModel.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                playerModel.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                playerModel.m_5585_().f_104203_ = 0.0f;
                playerModel.m_5585_().f_104204_ = 0.0f;
                playerModel.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

