/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.cache.CacheManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.screen.ScreenContainerData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandlerInterface;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class EasyNPCScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static double formerMouseX = -1.0;
    protected static double formerMouseY = -1.0;
    protected final Minecraft minecraftInstance;
    protected final ServerNetworkMessageHandlerInterface networkMessageHandler;
    protected final ScreenContainerData containerData;
    protected float xMouse;
    protected float yMouse;
    private boolean isInitialized = false;

    protected EasyNPCScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        if (menu instanceof EasyNPCMenu) {
            EasyNPCMenu easyNPCMenu = (EasyNPCMenu)((Object)menu);
            this.containerData = easyNPCMenu.getContainerData();
        } else {
            log.error("Failed to get container data for menu {}", menu);
            this.containerData = null;
        }
        this.minecraftInstance = Minecraft.m_91087_();
        this.networkMessageHandler = NetworkMessageHandlerManager.getServerHandler();
    }

    protected static void resetFormerMousePosition() {
        EasyNPCScreen.setFormerMousePosition(-1.0, -1.0);
    }

    protected static void setFormerMousePosition(double x, double y) {
        formerMouseX = x;
        formerMouseY = y;
    }

    protected void defineScreen() {
        log.info("Define Container data with {}, {} and {}", (Object)this.containerData.getNpcUUID(), (Object)this.containerData.getDialogUUID(), (Object)this.containerData.getPageIndex());
    }

    public void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
        this.m_7379_();
    }

    public UUID getNpcUUID() {
        return this.containerData.getNpcUUID();
    }

    public UUID getDialogUUID() {
        return this.containerData.getDialogUUID();
    }

    public int getPageIndex() {
        return this.containerData.getPageIndex();
    }

    public EasyNPC<?> getEasyNPC() {
        return LivingEntityManager.getEasyNPCEntityByUUID(this.containerData.getNpcUUID());
    }

    public boolean hasActionEventSet() {
        return CacheManager.hasActionDataSet(this.containerData.getNpcUUID());
    }

    public ActionEventSet getActionEventSet() {
        return CacheManager.getActionDataSet(this.containerData.getNpcUUID());
    }

    public boolean hasDialogDataSet() {
        return CacheManager.hasDialogDataSet(this.containerData.getNpcUUID());
    }

    public DialogDataSet getDialogDataSet() {
        return CacheManager.getDialogDataSet(this.containerData.getNpcUUID());
    }

    public boolean hasObjectiveDataSet() {
        return CacheManager.hasObjectiveDataSet(this.containerData.getNpcUUID());
    }

    public ObjectiveDataSet getObjectiveDataSet() {
        return CacheManager.getObjectiveDataSet(this.containerData.getNpcUUID());
    }

    public boolean isSynced() {
        return this.containerData != null && this.containerData.isSynced() && this.containerData.getNpcUUID() != null && CacheManager.hasCacheData(this.containerData.getNpcUUID());
    }

    public DialogDataEntry getDialogData() {
        if (!this.hasDialogDataSet()) {
            return null;
        }
        UUID dialogUUID = this.containerData.getDialogUUID();
        DialogDataSet dialogDataSet = CacheManager.getDialogDataSet(this.containerData.getNpcUUID());
        if (dialogUUID != null) {
            return dialogDataSet.getDialog(dialogUUID);
        }
        return dialogDataSet.getDefaultDialog();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 200;
        this.f_97726_ = 280;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        if (formerMouseX > 0.0 && formerMouseY > 0.0) {
            GLFW.glfwSetCursorPos((long)this.minecraftInstance.m_91268_().m_85439_(), (double)formerMouseX, (double)formerMouseY);
            EasyNPCScreen.resetFormerMousePosition();
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.isInitialized && this.isSynced()) {
            this.defineScreen();
            this.isInitialized = true;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        EasyNPCScreen.setFormerMousePosition(Minecraft.m_91087_().f_91067_.m_91589_(), Minecraft.m_91087_().f_91067_.m_91594_());
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
    }

    public void m_7379_() {
        EasyNPCScreen.resetFormerMousePosition();
        this.isInitialized = false;
        super.m_7379_();
    }
}

