/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.attribute;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.menu.configuration.attribute.BaseAttributeConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BaseAttributeConfigurationScreen
extends AttributeConfigurationScreen<BaseAttributeConfigurationMenu> {
    SliderButton maxHealthSlider;
    SliderButton followRangeSlider;
    SliderButton knockbackResistanceSlider;
    SliderButton movementSpeedSlider;
    SliderButton flyingSpeedSlider;
    SliderButton attackDamageSlider;
    SliderButton attackKnockbackSlider;
    SliderButton attackSpeedSlider;
    SliderButton armorSlider;
    SliderButton armorToughnessSlider;

    public BaseAttributeConfigurationScreen(BaseAttributeConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected SliderButton createAttributeSlider(int left, int top, int width, int height, String name, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        SliderButton sliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(left + 12, top, width - 36, height, name, value, minValue, maxValue, onChange));
        this.m_142416_((GuiEventListener)new TextButton(sliderButton.f_93620_ - 12, top, 12, height, (Component)Component.m_237113_((String)"-"), button -> {
            if (sliderButton.getTargetDoubleValue() - stepSize >= minValue) {
                sliderButton.setDefaultValue(sliderButton.getTargetDoubleValue() - stepSize);
                onChange.onChange(sliderButton);
            }
        }));
        Button plusButton = (Button)this.m_142416_((GuiEventListener)new TextButton(sliderButton.f_93620_ + sliderButton.m_5711_(), top, 12, height, (Component)Component.m_237113_((String)"+"), button -> {
            if (sliderButton.getTargetDoubleValue() + stepSize <= maxValue) {
                sliderButton.setDefaultValue(sliderButton.getTargetDoubleValue() + stepSize);
                onChange.onChange(sliderButton);
            }
        }));
        this.m_142416_((GuiEventListener)new TextButton(plusButton.f_93620_ + plusButton.m_5711_(), top, 12, height, (Component)Component.m_237113_((String)"\u21ba"), button -> {
            sliderButton.setDefaultValue(defaultValue);
            onChange.onChange(sliderButton);
        }));
        return sliderButton;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.baseAttributeButton.f_93623_ = false;
        int sliderXPos = this.buttonLeftPos + 125;
        int sliderYPos = this.buttonTopPos + 22;
        int sliderWidth = 170;
        int sliderHeight = 14;
        int sliderYSpace = 20;
        LivingEntity livingEntity = this.easyNPC.getLivingEntity();
        this.maxHealthSlider = this.createAttributeSlider(sliderXPos, sliderYPos, sliderWidth, sliderHeight, "max_health", livingEntity.m_21172_(Attributes.f_22276_), 1.0, 1024.0, 20.0, 1.0, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22276_, slider.getTargetDoubleValue()));
        this.followRangeSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "follow_range", ((BaseAttributeConfigurationMenu)this.f_97732_).getFollowRange(), 0.0, 2048.0, 32.0, 1.0, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22277_, slider.getTargetDoubleValue()));
        this.knockbackResistanceSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "knockback_resistance", ((BaseAttributeConfigurationMenu)this.f_97732_).getKnockbackResistance(), 0.0, 1.0, 0.0, 0.1, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22278_, slider.getTargetDoubleValue()));
        if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
            this.movementSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "movement_speed", livingEntity.m_21172_(Attributes.f_22279_), 0.0, 2.0, 0.6, 0.1, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22279_, slider.getTargetDoubleValue()));
        }
        if (livingEntity.m_21051_(Attributes.f_22280_) != null) {
            this.flyingSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "flying_speed", livingEntity.m_21172_(Attributes.f_22280_), 0.0, 2.0, 0.4, 0.1, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22280_, slider.getTargetDoubleValue()));
        }
        this.attackDamageSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "attack_damage", ((BaseAttributeConfigurationMenu)this.f_97732_).getAttackDamage(), 0.0, 2048.0, 2.0, 1.0, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22281_, slider.getTargetDoubleValue()));
        this.attackKnockbackSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "attack_knockback", ((BaseAttributeConfigurationMenu)this.f_97732_).getAttackKnockback(), 0.0, 5.0, 0.0, 0.1, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22282_, slider.getTargetDoubleValue()));
        if (livingEntity.m_21051_(Attributes.f_22283_) != null) {
            this.attackSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "attack_speed", livingEntity.m_21172_(Attributes.f_22283_), 0.0, 1024.0, 4.0, 0.5, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22283_, slider.getTargetDoubleValue()));
        }
        this.armorSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "armor", livingEntity.m_21172_(Attributes.f_22284_), 0.0, 30.0, 0.0, 1.0, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22284_, slider.getTargetDoubleValue()));
        this.armorToughnessSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, "armor_toughness", livingEntity.m_21172_(Attributes.f_22285_), 0.0, 20.0, 0.0, 0.5, slider -> ServerNetworkMessageHandler.entityBaseAttributeChange(this.uuid, Attributes.f_22285_, slider.getTargetDoubleValue()));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        int sliderXOffset = -145;
        int sliderYOffset = 3;
        if (this.maxHealthSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "max_health", this.maxHealthSlider.f_93620_ + sliderXOffset, this.maxHealthSlider.f_93621_ + sliderYOffset);
        }
        if (this.followRangeSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "follow_range", this.followRangeSlider.f_93620_ + sliderXOffset, this.followRangeSlider.f_93621_ + sliderYOffset);
        }
        if (this.knockbackResistanceSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "knockback_resistance", this.knockbackResistanceSlider.f_93620_ + sliderXOffset, this.knockbackResistanceSlider.f_93621_ + sliderYOffset);
        }
        if (this.movementSpeedSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "movement_speed", this.movementSpeedSlider.f_93620_ + sliderXOffset, this.movementSpeedSlider.f_93621_ + sliderYOffset);
        }
        if (this.flyingSpeedSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "flying_speed", this.flyingSpeedSlider.f_93620_ + sliderXOffset, this.flyingSpeedSlider.f_93621_ + sliderYOffset);
        }
        if (this.attackDamageSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "attack_damage", this.attackDamageSlider.f_93620_ + sliderXOffset, this.attackDamageSlider.f_93621_ + sliderYOffset);
        }
        if (this.attackKnockbackSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "attack_knockback", this.attackKnockbackSlider.f_93620_ + sliderXOffset, this.attackKnockbackSlider.f_93621_ + sliderYOffset);
        }
        if (this.attackSpeedSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "attack_speed", this.attackSpeedSlider.f_93620_ + sliderXOffset, this.attackSpeedSlider.f_93621_ + sliderYOffset);
        }
        if (this.armorSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "armor", this.armorSlider.f_93620_ + sliderXOffset, this.armorSlider.f_93621_ + sliderYOffset);
        }
        if (this.armorToughnessSlider != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "armor_toughness", this.armorToughnessSlider.f_93620_ + sliderXOffset, this.armorToughnessSlider.f_93621_ + sliderYOffset);
        }
    }
}

