/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PoseConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected final ModelData<?> modelData;
    protected Button defaultPoseButton;
    protected Button advancedPoseButton;
    protected Button customPoseButton;

    public PoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.modelData = this.easyNPC.getEasyNPCModelData();
    }

    protected SliderButton createRotationSlider(int left, int top, ModelPart modelPart, String label) {
        return this.createRotationSlider(left, top, modelPart, label, false);
    }

    protected SliderButton createRotationSliderCompact(int left, int top, ModelPart modelPart, String label) {
        return this.createRotationSlider(left, top, modelPart, label, true);
    }

    protected SliderButton createRotationSlider(int left, int top, ModelPart modelPart, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderLeftPosition = left;
        if (compact && (modelPart == ModelPart.BODY || modelPart == ModelPart.LEFT_ARM || modelPart == ModelPart.LEFT_LEG)) {
            sliderLeftPosition = left + 10;
        }
        CustomRotation modelPartRotation = this.modelData.getModelPartRotation(modelPart);
        SliderButton sliderButtonX = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderLeftPosition, top, sliderWidth, label + "RotationX", (float)Math.toDegrees(modelPartRotation.m_123156_()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            ServerNetworkMessageHandler.rotationChange(this.uuid, modelPart, new CustomRotation((float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.m_123157_(), currentModelPartRotation.m_123158_()));
        }));
        SliderButton sliderButtonY = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderButtonX.f_93620_ + sliderButtonX.m_5711_(), top, sliderWidth, label + "RotationY", (float)Math.toDegrees(modelPartRotation.m_123157_()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            ServerNetworkMessageHandler.rotationChange(this.uuid, modelPart, new CustomRotation(currentModelPartRotation.m_123156_(), (float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.m_123158_()));
        }));
        SliderButton sliderButtonZ = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderButtonY.f_93620_ + sliderButtonY.m_5711_(), top, sliderWidth, label + "RotationZ", (float)Math.toDegrees(modelPartRotation.m_123158_()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            ServerNetworkMessageHandler.rotationChange(this.uuid, modelPart, new CustomRotation(currentModelPartRotation.m_123156_(), currentModelPartRotation.m_123157_(), (float)Math.toRadians(slider.getTargetValue())));
        }));
        if (compact) {
            int resetButtonLeftPosition = switch (modelPart) {
                case ModelPart.BODY, ModelPart.LEFT_ARM, ModelPart.LEFT_LEG -> left;
                default -> sliderButtonZ.f_93620_ + sliderButtonZ.m_5711_();
            };
            this.m_142416_((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)Component.m_237113_((String)"\u21ba"), button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                ServerNetworkMessageHandler.rotationChange(this.uuid, modelPart, new CustomRotation(0.0f, 0.0f, 0.0f));
            }));
        } else {
            this.m_142416_((GuiEventListener)new TextButton(sliderButtonX.f_93620_, top + 16, sliderWidth * 3, "reset", button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                ServerNetworkMessageHandler.rotationChange(this.uuid, modelPart, new CustomRotation(0.0f, 0.0f, 0.0f));
            }));
        }
        return sliderButtonX;
    }

    protected SliderButton createPositionSlider(int left, int top, ModelPart modelPart, String label) {
        return this.createPositionSlider(left, top, modelPart, label, false);
    }

    protected SliderButton createPositionSliderCompact(int left, int top, ModelPart modelPart, String label) {
        return this.createPositionSlider(left, top, modelPart, label, true);
    }

    protected SliderButton createPositionSlider(int left, int top, ModelPart modelPart, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderLeftPosition = left;
        if (compact && (modelPart == ModelPart.BODY || modelPart == ModelPart.LEFT_ARM || modelPart == ModelPart.LEFT_LEG)) {
            sliderLeftPosition = left + 10;
        }
        CustomPosition modelPartPosition = this.modelData.getModelPartPosition(modelPart);
        SliderButton sliderButtonX = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderLeftPosition, top, sliderWidth, label + "PositionX", modelPartPosition.x(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            ServerNetworkMessageHandler.modelPositionChange(this.uuid, modelPart, new CustomPosition(slider.getTargetValue(), currentModelPartPosition.y(), currentModelPartPosition.z()));
        }));
        SliderButton sliderButtonY = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderButtonX.f_93620_ + sliderButtonX.m_5711_(), top, sliderWidth, label + "PositionY", modelPartPosition.y(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            ServerNetworkMessageHandler.modelPositionChange(this.uuid, modelPart, new CustomPosition(currentModelPartPosition.x(), slider.getTargetValue(), currentModelPartPosition.z()));
        }));
        SliderButton sliderButtonZ = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(sliderButtonY.f_93620_ + sliderButtonY.m_5711_(), top, sliderWidth, label + "PositionZ", modelPartPosition.z(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            ServerNetworkMessageHandler.modelPositionChange(this.uuid, modelPart, new CustomPosition(currentModelPartPosition.x(), currentModelPartPosition.y(), slider.getTargetValue()));
        }));
        if (compact) {
            int resetButtonLeftPosition = switch (modelPart) {
                case ModelPart.BODY, ModelPart.LEFT_ARM, ModelPart.LEFT_LEG -> left;
                default -> sliderButtonZ.f_93620_ + sliderButtonZ.m_5711_();
            };
            this.m_142416_((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)Component.m_237113_((String)"\u21ba"), button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                ServerNetworkMessageHandler.modelPositionChange(this.uuid, modelPart, new CustomPosition(0.0f, 0.0f, 0.0f));
            }));
        } else {
            this.m_142416_((GuiEventListener)new TextButton(sliderButtonX.f_93620_, top + 20, sliderWidth * 3, "reset", button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                ServerNetworkMessageHandler.modelPositionChange(this.uuid, modelPart, new CustomPosition(0.0f, 0.0f, 0.0f));
            }));
        }
        return sliderButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int poseButtonWidth = 80;
        this.defaultPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, poseButtonWidth - 10, "default", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSE)));
        this.advancedPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos + this.defaultPoseButton.m_5711_(), this.buttonTopPos, poseButtonWidth + 10, "advanced", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_POSE)));
        this.customPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.advancedPoseButton.f_93620_ + this.advancedPoseButton.m_5711_(), this.buttonTopPos, poseButtonWidth + 20, "custom", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_POSE)));
        this.defaultPoseButton.f_93623_ = this.supportsPoseConfiguration && this.supportsStandardPoseConfiguration && this.hasPermissions((Boolean)PoseConfigurationScreen.COMMON.defaultPoseConfigurationEnabled.get(), (Boolean)PoseConfigurationScreen.COMMON.defaultPoseConfigurationAllowInCreative.get(), (Integer)PoseConfigurationScreen.COMMON.defaultPoseConfigurationPermissionLevel.get());
        this.advancedPoseButton.f_93623_ = this.supportsPoseConfiguration && this.supportsAdvancedPoseConfiguration && this.hasPermissions((Boolean)PoseConfigurationScreen.COMMON.advancedPoseConfigurationEnabled.get(), (Boolean)PoseConfigurationScreen.COMMON.advancedPoseConfigurationAllowInCreative.get(), (Integer)PoseConfigurationScreen.COMMON.advancedPoseConfigurationPermissionLevel.get());
        this.customPoseButton.f_93623_ = this.supportsPoseConfiguration && this.supportsCustomPoseConfiguration && this.hasPermissions((Boolean)PoseConfigurationScreen.COMMON.customPoseConfigurationEnabled.get(), (Boolean)PoseConfigurationScreen.COMMON.customPoseConfigurationAllowInCreative.get(), (Integer)PoseConfigurationScreen.COMMON.customPoseConfigurationPermissionLevel.get());
    }
}

