/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.preset.ExportPresetConfigurationScreen;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.preset.WorldExportPresetConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExportWorldPresetConfigurationScreen
extends ExportPresetConfigurationScreen<WorldExportPresetConfigurationMenu> {
    protected Button exportPresetButton;
    protected int numberOfTextLines = 1;
    private EditBox nameBox;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public ExportWorldPresetConfigurationScreen(WorldExportPresetConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        this.exportPresetButton.f_93623_ = nameValue != null && !nameValue.isEmpty();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.worldExportPresetButton.f_93623_ = false;
        File customPresetFile = CustomPresetDataFiles.getPresetFile(this.skinModel, this.uuid);
        String customPresetFileName = customPresetFile.getName();
        this.nameBox = new TextField(this.f_96547_, this.contentLeftPos + 5, this.bottomPos - 65, 270);
        this.nameBox.m_94199_(64);
        this.nameBox.m_94144_(customPresetFileName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.textComponents = this.f_96547_.m_92923_((FormattedText)Component.m_237110_((String)"text.easy_npc.config.export_preset_world_text", (Object[])new Object[]{customPresetFile.getParentFile(), customPresetFile.getName()}), this.f_97726_ - 25);
        this.numberOfTextLines = this.textComponents.size();
        this.exportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 65, this.bottomPos - 40, 150, "export", button -> {
            ServerNetworkMessageHandler.exportPresetWorld(this.uuid, this.nameBox.m_94155_());
            this.exportPresetButton.f_93623_ = false;
        }));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(poseStack, this.f_96547_, formattedCharSequence, this.f_97735_ + 15, this.f_97736_ + 80 + line * (9 + 2));
            }
        }
    }
}

