/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportPresetConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static ResourceLocation selectedPreset;
    protected static List<ResourceLocation> presetList;
    protected Button localImportPresetButton;
    protected Button customImportPresetButton;
    protected Button defaultImportPresetButton;
    protected Button worldImportPresetButton;
    protected String importPresetButtonLabel = "import_preset";
    protected String importPresetHeaderLabel = "import_preset_header";
    protected Button importPresetButton;
    ImportFileSelectionList presetSelectionList;

    public ImportPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static void updateSelectedPreset(ResourceLocation resourceLocation) {
        selectedPreset = resourceLocation;
    }

    public static void updatePresets(List<ResourceLocation> presets) {
        presetList = presets;
    }

    public static List<ResourceLocation> getPresets() {
        return presetList;
    }

    public static boolean hasNoPresets() {
        return presetList == null || presetList.isEmpty();
    }

    public void loadPresetConfirm(ResourceLocation resourceLocation) {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                this.loadPreset(resourceLocation);
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)Component.m_237110_((String)"text.easy_npc.config.preset.importQuestion", (Object[])new Object[]{resourceLocation.m_135815_().substring(resourceLocation.m_135815_().lastIndexOf("/") + 1)}), (Component)Component.m_237110_((String)"text.easy_npc.config.preset.importWarning", (Object[])new Object[]{this.easyNPC.getEntity().m_5446_().getString()}), (Component)Component.m_237115_((String)"text.easy_npc.config.preset.importButton"), CommonComponents.f_130656_));
    }

    public void loadPreset(ResourceLocation resourceLocation) {
    }

    public String getPresetFileName(ResourceLocation resourceLocation) {
        return resourceLocation.m_135815_().replace("preset/" + this.skinModel.toString().toLowerCase() + "/", "").replace(".npc.nbt", "");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 70;
        this.localImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth - 4, "local", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.LOCAL_PRESET_IMPORT)));
        this.localImportPresetButton.f_93623_ = false;
        this.defaultImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.localImportPresetButton.f_93620_ + this.localImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth - 4, "default", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_PRESET_IMPORT)));
        this.defaultImportPresetButton.f_93623_ = false;
        this.worldImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.defaultImportPresetButton.f_93620_ + this.defaultImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth - 6, "world_preset", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.WORLD_PRESET_IMPORT)));
        this.worldImportPresetButton.f_93623_ = false;
        this.customImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.worldImportPresetButton.f_93620_ + this.worldImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth + 15, "custom", button -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_PRESET_IMPORT)));
        this.customImportPresetButton.f_93623_ = false;
        this.localImportPresetButton.f_93623_ = this.hasPermissions((Boolean)ImportPresetConfigurationScreen.COMMON.localImportPresetConfigurationEnabled.get(), (Boolean)ImportPresetConfigurationScreen.COMMON.localImportPresetConfigurationAllowInCreative.get(), (Integer)ImportPresetConfigurationScreen.COMMON.localImportPresetConfigurationPermissionLevel.get()) && CustomPresetDataFiles.hasPresetFiles(this.skinModel);
        this.defaultImportPresetButton.f_93623_ = this.hasPermissions((Boolean)ImportPresetConfigurationScreen.COMMON.defaultImportPresetConfigurationEnabled.get(), (Boolean)ImportPresetConfigurationScreen.COMMON.defaultImportPresetConfigurationAllowInCreative.get(), (Integer)ImportPresetConfigurationScreen.COMMON.defaultImportPresetConfigurationPermissionLevel.get());
        this.worldImportPresetButton.f_93623_ = this.hasPermissions((Boolean)ImportPresetConfigurationScreen.COMMON.worldImportPresetConfigurationEnabled.get(), (Boolean)ImportPresetConfigurationScreen.COMMON.worldImportPresetConfigurationAllowInCreative.get(), (Integer)ImportPresetConfigurationScreen.COMMON.worldImportPresetConfigurationPermissionLevel.get());
        this.customImportPresetButton.f_93623_ = this.hasPermissions((Boolean)ImportPresetConfigurationScreen.COMMON.customImportPresetConfigurationEnabled.get(), (Boolean)ImportPresetConfigurationScreen.COMMON.customImportPresetConfigurationAllowInCreative.get(), (Integer)ImportPresetConfigurationScreen.COMMON.customImportPresetConfigurationPermissionLevel.get());
        this.presetSelectionList = new ImportFileSelectionList(this.f_96541_);
        this.m_7787_((GuiEventListener)this.presetSelectionList);
        ImportPresetConfigurationScreen.updateSelectedPreset(null);
        this.importPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos + 25, this.bottomPos - 40, 220, this.importPresetButtonLabel, button -> {
            if (selectedPreset != null) {
                this.loadPresetConfirm(selectedPreset);
            }
        }));
        this.importPresetButton.f_93623_ = false;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.presetSelectionList.m_6305_(poseStack, x, y, partialTicks);
        this.importPresetButton.f_93623_ = selectedPreset != null;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int fileListTop = this.f_97736_ + 55;
        int fileListHeight = fileListTop + 110;
        int fileListWidth = this.f_97735_ + 290;
        ImportPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos - 1), (int)(fileListTop - 1), (int)(fileListWidth + 1), (int)(fileListHeight + 1), (int)-16777216);
        ImportPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)fileListTop, (int)fileListWidth, (int)fileListHeight, (int)-5592406);
    }

    class ImportFileSelectionList
    extends ObjectSelectionList<de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
        public ImportFileSelectionList(Minecraft minecraft) {
            super(minecraft, ImportPresetConfigurationScreen.this.f_96543_ - 5, ImportPresetConfigurationScreen.this.f_96544_ - 150 + 66, ImportPresetConfigurationScreen.this.f_97736_ + 66, ImportPresetConfigurationScreen.this.f_96544_ - 150 - ImportPresetConfigurationScreen.this.f_97736_ + 66, 14);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            this.updatePresets();
        }

        public void updatePresets() {
            this.m_93516_();
            if (ImportPresetConfigurationScreen.hasNoPresets()) {
                return;
            }
            ImportPresetConfigurationScreen.getPresets().forEach(resourceLocation -> {
                Entry entry = new Entry((ResourceLocation)resourceLocation, ImportPresetConfigurationScreen.this.skinModel);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            });
        }

        protected int m_5756_() {
            return super.m_5756_() + 12;
        }

        public int m_5759_() {
            return super.m_5759_() + 40;
        }

        protected boolean m_5694_() {
            return ImportPresetConfigurationScreen.this.m_7222_() == this;
        }

        public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_6305_(poseStack, x, y, partialTicks);
                return;
            }
            Text.drawConfigStringShadow(poseStack, ImportPresetConfigurationScreen.this.f_96547_, "no_presets_found", ImportPresetConfigurationScreen.this.contentLeftPos + 80, ImportPresetConfigurationScreen.this.f_97736_ + 105, 0xFFFFFF);
        }

        public class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
            final ResourceLocation resourceLocation;
            final SkinModel skinModel;
            final String fileName;

            public Entry(ResourceLocation resourceLocation, SkinModel skinModel) {
                this.resourceLocation = resourceLocation;
                this.skinModel = skinModel;
                this.fileName = ImportPresetConfigurationScreen.this.getPresetFileName(resourceLocation);
            }

            public void m_6311_(PoseStack poseStack, int x, int y, int unused1, int unused2, int unused3, int unused4, int unused5, boolean unused6, float partialTicks) {
                int fileListTop = ImportPresetConfigurationScreen.this.f_97736_ + 55;
                int fileListWidth = ImportPresetConfigurationScreen.this.f_97735_ + 290;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(ImportPresetConfigurationScreen.this.contentLeftPos - 1), (int)(fileListTop - 4), (int)(fileListWidth + 1), (int)(fileListTop + 12), (int)-16777216);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)ImportPresetConfigurationScreen.this.contentLeftPos, (int)(fileListTop - 3), (int)fileListWidth, (int)(fileListTop + 11), (int)-7829368);
                Text.drawConfigStringShadowWithData(poseStack, ImportPresetConfigurationScreen.this.f_96547_, ImportPresetConfigurationScreen.this.importPresetHeaderLabel, (Object)this.skinModel, ImportPresetConfigurationScreen.this.contentLeftPos + 3, fileListTop, 0xFFFFFF);
                Text.drawStringShadow(poseStack, ImportPresetConfigurationScreen.this.f_96547_, this.fileName, ImportFileSelectionList.this.f_93388_ / 2 - ImportPresetConfigurationScreen.this.f_96547_.m_92895_(this.fileName) / 2, y + 1, 0xFFFFFF);
            }

            public boolean m_6375_(double unused1, double unused2, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ImportFileSelectionList.this.m_6987_((AbstractSelectionList.Entry)this);
                log.debug("Selected file {}.", (Object)this.resourceLocation);
                ImportPresetConfigurationScreen.updateSelectedPreset(this.resourceLocation);
            }

            public Component m_142172_() {
                return Component.m_237115_((String)this.resourceLocation.m_135815_());
            }
        }
    }
}

