/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.scaling;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.menu.configuration.scaling.ScalingConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScalingConfigurationScreen
extends ConfigurationScreen<ScalingConfigurationMenu> {
    private static final int DIMENSION_UPDATE_TICK = 20;
    private final ScaleData<?> scaleData = this.easyNPC.getEasyNPCScaleData();
    protected Button defaultScaleButton;
    protected Button defaultScaleXButton;
    protected Button defaultScaleYButton;
    protected Button defaultScaleZButton;
    protected SliderButton scaleXSliderButton;
    protected SliderButton scaleYSliderButton;
    protected SliderButton scaleZSliderButton;
    private int dimensionUpdateTicker = 0;

    public ScalingConfigurationScreen(ScalingConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        this.defaultScaleButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "scaling", button -> {}));
        this.defaultScaleButton.f_93623_ = false;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
        int scalePositionLeft = this.contentLeftPos + 160;
        int scalePositionTop = this.contentTopPos + 20;
        int scalePositionSpace = 60;
        int scaleWidth = 140;
        this.scaleXSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(scalePositionLeft, scalePositionTop, scaleWidth, 20, this.scaleData.getScaleX().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (this.scaleData.getScaleX().floatValue() != scale) {
                ServerNetworkMessageHandler.scaleChange(this.uuid, "x", button.getTargetValue());
            }
            this.defaultScaleXButton.f_93623_ = scale != this.scaleData.getDefaultScaleX().floatValue();
        }));
        this.defaultScaleXButton = (Button)this.m_142416_((GuiEventListener)new TextButton(scalePositionLeft, scalePositionTop + this.scaleXSliderButton.m_93694_(), scaleWidth, "reset", button -> this.scaleXSliderButton.setDefaultValue(this.scaleData.getDefaultScaleX().floatValue())));
        this.defaultScaleXButton.f_93623_ = !this.scaleData.getScaleX().equals(this.scaleData.getDefaultScaleX());
        this.scaleYSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace, scaleWidth, 20, this.scaleData.getScaleY().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (this.scaleData.getScaleY().floatValue() != scale) {
                ServerNetworkMessageHandler.scaleChange(this.uuid, "y", button.getTargetValue());
            }
            this.defaultScaleYButton.f_93623_ = scale != this.scaleData.getDefaultScaleY().floatValue();
        }));
        this.defaultScaleYButton = (Button)this.m_142416_((GuiEventListener)new TextButton(scalePositionLeft, scalePositionTop + this.scaleYSliderButton.m_93694_() + scalePositionSpace, scaleWidth, "reset", button -> this.scaleYSliderButton.setDefaultValue(this.scaleData.getDefaultScaleY().floatValue())));
        this.defaultScaleYButton.f_93623_ = !this.scaleData.getScaleY().equals(this.scaleData.getDefaultScaleY());
        this.scaleZSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace * 2, scaleWidth, 20, this.scaleData.getScaleZ().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (this.scaleData.getScaleZ().floatValue() != scale) {
                ServerNetworkMessageHandler.scaleChange(this.uuid, "z", button.getTargetValue());
            }
            this.defaultScaleZButton.f_93623_ = scale != this.scaleData.getDefaultScaleZ().floatValue();
        }));
        this.defaultScaleZButton = (Button)this.m_142416_((GuiEventListener)new TextButton(scalePositionLeft, scalePositionTop + this.scaleZSliderButton.m_93694_() + scalePositionSpace * 2, scaleWidth, "reset", button -> this.scaleZSliderButton.setDefaultValue(this.scaleData.getDefaultScaleZ().floatValue())));
        this.defaultScaleZButton.f_93623_ = !this.scaleData.getScaleZ().equals(this.scaleData.getDefaultScaleZ());
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.easyNPC.getEntity() != null && this.dimensionUpdateTicker++ > 20) {
            this.easyNPC.getEntity().m_6210_();
            this.dimensionUpdateTicker = 0;
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        ScreenHelper.renderEntityAvatarForScaling(this.contentLeftPos + 70, this.contentTopPos + 175, 30, (float)(this.contentLeftPos + 140) - this.xMouse, (float)(this.contentTopPos + 30) - this.yMouse, this.easyNPC);
        Text.drawConfigString(poseStack, this.f_96547_, "scale_x", this.scaleXSliderButton.f_93620_, this.scaleXSliderButton.f_93621_ - 10);
        Text.drawConfigString(poseStack, this.f_96547_, "scale_y", this.scaleYSliderButton.f_93620_, this.scaleYSliderButton.f_93621_ - 10);
        Text.drawConfigString(poseStack, this.f_96547_, "scale_z", this.scaleZSliderButton.f_93620_, this.scaleZSliderButton.f_93621_ - 10);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 149), (int)(this.contentTopPos + 187), (int)-16777216);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 186), (int)-5592406);
        int scaleLinesColor = -1437248171;
        Text.drawString(poseStack, this.f_96547_, "0", this.contentLeftPos + 4, this.contentTopPos + 172, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 175), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 176), (int)scaleLinesColor);
        Text.drawString(poseStack, this.f_96547_, "0.5", this.contentLeftPos + 4, this.contentTopPos + 141, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 144), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 145), (int)scaleLinesColor);
        Text.drawString(poseStack, this.f_96547_, "1.0", this.contentLeftPos + 4, this.contentTopPos + 111, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 114), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 115), (int)scaleLinesColor);
        Text.drawString(poseStack, this.f_96547_, "1.5", this.contentLeftPos + 4, this.contentTopPos + 81, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 84), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 85), (int)scaleLinesColor);
        Text.drawString(poseStack, this.f_96547_, "2.0", this.contentLeftPos + 4, this.contentTopPos + 51, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 54), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 55), (int)scaleLinesColor);
        Text.drawString(poseStack, this.f_96547_, "2.5", this.contentLeftPos + 4, this.contentTopPos + 21, scaleLinesColor);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(this.contentTopPos + 24), (int)(this.contentLeftPos + 148), (int)(this.contentTopPos + 25), (int)scaleLinesColor);
    }
}

