/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SKIN_PREVIEW_WIDTH = 60;
    protected Button noneSkinButton = null;
    protected Button customSkinButton = null;
    protected Button defaultSkinButton = null;
    protected Button playerSkinButton = null;
    protected Button urlSkinButton = null;
    protected Button skinPreviousButton = null;
    protected Button skinNextButton = null;
    protected Button skinPreviousPageButton = null;
    protected Button skinNextPageButton = null;
    protected int skinStartIndex = 0;
    protected int numOfSkins = 0;
    protected int maxSkinsPerPage = 5;
    protected List<Button> skinButtons = new ArrayList<Button>();

    public SkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void checkSkinNavigationButtonState() {
        boolean skinButtonShouldBeVisible;
        boolean bl = skinButtonShouldBeVisible = this.numOfSkins > this.maxSkinsPerPage;
        if (this.skinPreviousButton != null) {
            this.skinPreviousButton.f_93624_ = skinButtonShouldBeVisible;
        }
        if (this.skinNextButton != null) {
            this.skinNextButton.f_93624_ = skinButtonShouldBeVisible;
        }
        if (this.skinPreviousPageButton != null) {
            this.skinPreviousPageButton.f_93624_ = skinButtonShouldBeVisible;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.f_93624_ = skinButtonShouldBeVisible;
        }
        if (this.skinPreviousButton != null) {
            boolean bl2 = this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl3 = this.skinNextButton.f_93623_ = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl4 = this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - this.maxSkinsPerPage > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
        }
    }

    protected void renderSkinSelectionBackground(PoseStack poseStack) {
        SkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.f_97736_ + 102), (int)(this.contentLeftPos + 302), (int)(this.f_97736_ + 188), (int)-16777216);
        SkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.f_97736_ + 103), (int)(this.contentLeftPos + 301), (int)(this.f_97736_ + 187), (int)-5592406);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.noneSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, 44, "disable_skin", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.NONE_SKIN)));
        this.defaultSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.noneSkinButton.f_93620_ + this.noneSkinButton.m_5711_(), this.buttonTopPos, 64, "default", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.DEFAULT_SKIN)));
        this.playerSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.defaultSkinButton.f_93620_ + this.defaultSkinButton.m_5711_(), this.buttonTopPos, 62, "player_skin", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.PLAYER_SKIN)));
        this.urlSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.supportsPlayerSkinConfiguration ? this.playerSkinButton.f_93620_ + this.playerSkinButton.m_5711_() : this.defaultSkinButton.f_93620_ + this.defaultSkinButton.m_5711_(), this.buttonTopPos, 40, "url_skin", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.URL_SKIN)));
        this.customSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.urlSkinButton.f_93620_ + this.urlSkinButton.m_5711_(), this.buttonTopPos, 80, "custom", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.CUSTOM_SKIN)));
        this.noneSkinButton.f_93623_ = this.supportsSkinConfiguration && this.supportsNoneSkinConfiguration && this.hasPermissions((Boolean)SkinConfigurationScreen.COMMON.noneSkinConfigurationEnabled.get(), (Boolean)SkinConfigurationScreen.COMMON.noneSkinConfigurationAllowInCreative.get(), (Integer)SkinConfigurationScreen.COMMON.noneSkinConfigurationPermissionLevel.get());
        this.customSkinButton.f_93623_ = this.supportsSkinConfiguration && this.supportsCustomSkinConfiguration && this.hasPermissions((Boolean)SkinConfigurationScreen.COMMON.customSkinConfigurationEnabled.get(), (Boolean)SkinConfigurationScreen.COMMON.customSkinConfigurationAllowInCreative.get(), (Integer)SkinConfigurationScreen.COMMON.customSkinConfigurationPermissionLevel.get());
        this.defaultSkinButton.f_93623_ = this.supportsSkinConfiguration && this.supportsDefaultSkinConfiguration && this.hasPermissions((Boolean)SkinConfigurationScreen.COMMON.defaultSkinConfigurationEnabled.get(), (Boolean)SkinConfigurationScreen.COMMON.defaultSkinConfigurationAllowInCreative.get(), (Integer)SkinConfigurationScreen.COMMON.defaultSkinConfigurationPermissionLevel.get());
        this.playerSkinButton.f_93623_ = this.supportsSkinConfiguration && this.supportsPlayerSkinConfiguration && this.hasPermissions((Boolean)SkinConfigurationScreen.COMMON.playerSkinConfigurationEnabled.get(), (Boolean)SkinConfigurationScreen.COMMON.playerSkinConfigurationAllowInCreative.get(), (Integer)SkinConfigurationScreen.COMMON.playerSkinConfigurationPermissionLevel.get());
        this.urlSkinButton.f_93623_ = this.supportsSkinConfiguration && this.supportsUrlSkinConfiguration && this.hasPermissions((Boolean)SkinConfigurationScreen.COMMON.urlSkinConfigurationEnabled.get(), (Boolean)SkinConfigurationScreen.COMMON.urlSkinConfigurationAllowInCreative.get(), (Integer)SkinConfigurationScreen.COMMON.urlSkinConfigurationPermissionLevel.get());
        this.playerSkinButton.f_93624_ = this.supportsPlayerSkinConfiguration;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(poseStack);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

