/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationScreen;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.trading.BasicTradingConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasicTradingConfigurationScreen
extends TradingConfigurationScreen<BasicTradingConfigurationMenu> {
    protected final TradingData<?> tradingData;
    protected EditBox resetsEveryMinEditBox;
    protected EditBox maxUsesEditBox;
    protected EditBox rewardExpEditBox;

    public BasicTradingConfigurationScreen(BasicTradingConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.tradingData = this.easyNPC.getEasyNPCTradingData();
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (BasicTradingConfigurationScreen.isNumericValue(text) && !text.isEmpty()) {
            ServerNetworkMessageHandler.setBasicTradingResetsEveryMin(this.uuid, Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(String text) {
        if (BasicTradingConfigurationScreen.isPositiveNumericValue(text) && !text.isEmpty()) {
            ServerNetworkMessageHandler.setBasicTradingMaxUses(this.uuid, Integer.parseInt(text));
        }
    }

    private void onRewardExpEditBoxChanged(String text) {
        if (BasicTradingConfigurationScreen.isNumericValue(text) && !text.isEmpty()) {
            ServerNetworkMessageHandler.setBasicTradingRewardExp(this.uuid, Integer.parseInt(text));
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicTradesButton.f_93623_ = false;
        this.resetsEveryMinEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 122, 32);
        this.resetsEveryMinEditBox.m_94199_(3);
        this.resetsEveryMinEditBox.m_94144_("" + this.tradingData.getTradingResetsEveryMin());
        this.resetsEveryMinEditBox.m_94151_(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isNumericValue(x$0));
        this.m_142416_((GuiEventListener)this.resetsEveryMinEditBox);
        this.maxUsesEditBox = new PositiveNumberField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 145, 32);
        this.maxUsesEditBox.m_94199_(4);
        this.maxUsesEditBox.m_94144_("" + this.tradingData.getBasicTradingMaxUses());
        this.maxUsesEditBox.m_94151_(this::onMaxUsesEditBoxChanged);
        this.m_142416_((GuiEventListener)this.maxUsesEditBox);
        this.rewardExpEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 168, 32);
        this.rewardExpEditBox.m_94199_(3);
        this.rewardExpEditBox.m_94144_("" + this.tradingData.getBasicTradingRewardExp());
        this.rewardExpEditBox.m_94151_(this::onRewardExpEditBoxChanged);
        this.rewardExpEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isNumericValue(x$0));
        this.m_142416_((GuiEventListener)this.rewardExpEditBox);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.m_7025_(poseStack, x, y);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        int slotPositionX = this.f_97735_ + 30 - 1;
        int slotPositionY = this.f_97736_ + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = this.f_97735_ + 190 - 1;
                slotPositionY = this.f_97736_ + 40 - 1;
            }
            Text.drawString(poseStack, this.f_96547_, (tradingOffer < 9 ? " " : "") + (tradingOffer + 1) + ".", slotPositionX - 15, slotPositionY + 5, 0x404040);
            int itemASlotLeftPosition = slotPositionX;
            int itemASlotTopPosition = slotPositionY;
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
            this.m_93228_(poseStack, itemASlotLeftPosition, itemASlotTopPosition, 7, 7, 18, 18);
            Text.drawString(poseStack, this.f_96547_, "+", itemASlotLeftPosition + 18 + 6, itemASlotTopPosition + 5, 0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
            this.m_93228_(poseStack, itemBSlotLeftPosition, itemBSlotTopPosition, 7, 7, 18, 18);
            Text.drawString(poseStack, this.f_96547_, "=", itemBSlotLeftPosition + 18 + 12, itemBSlotTopPosition + 5, 0x404040);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
            this.m_93228_(poseStack, slotPositionX + 82, slotPositionY, 7, 7, 18, 18);
            slotPositionY += 19;
        }
        this.m_93228_(poseStack, this.contentLeftPos, this.contentTopPos + 115, 7, 83, 162, 54);
        this.m_93228_(poseStack, this.contentLeftPos, this.contentTopPos + 171, 7, 141, 162, 18);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.minutes_for_trade_reset", this.contentLeftPos + 202, this.contentTopPos + 127, 0x404040);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.max_uses_per_trade", this.contentLeftPos + 202, this.contentTopPos + 150, 0x404040);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.rewarded_exp_per_trade", this.contentLeftPos + 202, this.contentTopPos + 173, 0x404040);
    }
}

