/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.editor.DialogEditorMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogEditorScreen
extends AbstractContainerScreen<DialogEditorMenu> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final int MAX_NUMBER_OF_BUTTONS = 6;
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final DialogDataSet dialogDataSet;
    protected final DialogDataEntry dialogData;
    protected final Set<DialogButtonData> dialogButtons;
    protected final EasyNPC<?> easyNPC;
    protected final UUID uuid;
    protected final ConfigurationType formerConfigurationType;
    protected UUID dialogId;
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogTextButton;
    protected Button addDialogButton;
    protected Button closeButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField dialogLabelTextField;
    protected Checkbox dialogLabelCheckbox;
    protected Button dialogNameToLabelButton;
    protected TextField dialogNameTextField;
    protected Checkbox dialogTranslateCheckbox;
    protected int bottomPos;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    private String dialogNameValue = "";
    private String dialogLabelValue = "";
    private boolean dialogTranslateValue = false;

    @OnlyIn(value=Dist.CLIENT)
    public DialogEditorScreen(DialogEditorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.uuid = menu.getUUID();
        this.easyNPC = menu.getEasyNPC();
        this.dialogDataSet = menu.getDialogDataSet();
        this.dialogData = menu.getDialogData();
        this.dialogButtons = this.dialogData.getButtons();
        this.dialogId = menu.getDialogId();
        this.formerConfigurationType = menu.getFormerConfigurationType();
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance.f_91074_;
        this.clientLevel = this.minecraftInstance.f_91073_;
    }

    private void openPreviousScreen() {
        if (this.formerConfigurationType == ConfigurationType.DIALOG_EDITOR) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_DIALOG);
        } else if (this.formerConfigurationType != null) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, this.formerConfigurationType);
        } else if (this.dialogDataSet.getType() == DialogType.YES_NO) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
        } else {
            this.closeScreen();
        }
    }

    private void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
    }

    private void deleteDialog() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                ServerNetworkMessageHandler.removeDialog(this.uuid, this.dialogId);
                this.openPreviousScreen();
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)Component.m_237115_((String)"text.easy_npc.removeDialog.deleteQuestion"), (Component)Component.m_237110_((String)"text.easy_npc.removeDialog.deleteWarning", (Object[])new Object[]{this.dialogData.getName()}), (Component)Component.m_237115_((String)"text.easy_npc.removeDialog.deleteButton"), CommonComponents.f_130656_));
    }

    protected void renderEditLabels(PoseStack poseStack) {
        Text.drawConfigString(poseStack, this.f_96547_, "dialog.name", this.f_97735_ + 10, this.dialogNameTextField.f_93621_ + 4, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "label_id", this.f_97735_ + 10, this.dialogLabelTextField.f_93621_ + 4, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "dialog.text", this.f_97735_ + 10, this.dialogTextButton.f_93621_ - 14, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "dialog.buttons", this.f_97735_ + 10, this.dialogTranslateCheckbox.f_93621_ + 22, 0);
    }

    protected void saveDialogData() {
        boolean hasChanged;
        boolean bl = hasChanged = !this.dialogNameTextField.m_94155_().equals(this.dialogNameValue) || !this.dialogLabelTextField.m_94155_().equals(this.dialogLabelValue) || this.dialogTranslateCheckbox.selected() != this.dialogTranslateValue;
        if (!hasChanged) {
            return;
        }
        this.dialogData.setName(this.dialogNameTextField.m_94155_());
        this.dialogData.setLabel(this.dialogLabelTextField.m_94155_());
        this.dialogData.setTranslate(this.dialogTranslateCheckbox.selected());
        ServerNetworkMessageHandler.saveDialog(this.uuid, this.dialogId, this.dialogData);
        if (!this.dialogLabelTextField.m_94155_().equals(this.dialogLabelValue)) {
            this.dialogId = this.dialogData.getId();
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 318;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(true);
        }
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.f_97735_ + 7, this.f_97736_ + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogData.getName(21), onPress -> {}));
        this.dialogButton.f_93623_ = false;
        this.dialogNameValue = this.dialogData.getName();
        this.dialogNameTextField = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 30, 150, this.dialogNameValue);
        this.dialogNameTextField.m_94199_(64);
        this.m_142416_((GuiEventListener)this.dialogNameTextField);
        this.dialogNameToLabelButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.dialogNameTextField.f_93620_ + this.dialogNameTextField.m_5711_() + 1, this.dialogNameTextField.f_93621_ - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.dialogNameTextField != null && this.dialogLabelTextField != null) {
                String buttonName = this.dialogNameTextField.m_94155_();
                this.dialogLabelTextField.m_94144_(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.dialogLabelValue = this.dialogData.getLabel();
        this.dialogLabelTextField = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 50, 100);
        this.dialogLabelTextField.m_94199_(32);
        this.dialogLabelTextField.m_94144_(this.dialogLabelValue);
        this.dialogLabelTextField.m_94186_(this.dialogLabelTextField.m_94155_().isEmpty());
        this.m_142416_((GuiEventListener)this.dialogLabelTextField);
        this.dialogLabelCheckbox = new Checkbox(this.f_97735_ + 203, this.dialogLabelTextField.f_93621_ + 1, "locked", !this.dialogData.getLabel().isEmpty(), checkbox -> this.dialogLabelTextField.m_94186_(!checkbox.selected()));
        this.m_142416_((GuiEventListener)this.dialogLabelCheckbox);
        this.dialogTextButton = (Button)this.m_142416_((GuiEventListener)new TextEditButton(this.f_97735_ + 7, this.f_97736_ + 105, 303, "dialog.edit_text", onPress -> {
            this.saveDialogData();
            ServerNetworkMessageHandler.openDialogTextEditor(this.uuid, this.dialogId, ConfigurationType.DIALOG_EDITOR);
        }));
        this.dialogTranslateValue = this.dialogData.getTranslate();
        this.dialogTranslateCheckbox = new Checkbox(this.f_97735_ + 15, this.f_97736_ + 110, "dialog.translate", this.dialogTranslateValue);
        this.m_142416_((GuiEventListener)this.dialogTranslateCheckbox);
        this.dialogTranslateCheckbox.f_93624_ = false;
        boolean smallButtons = this.dialogButtons.size() < 4;
        int buttonIndex = 0;
        int buttonBaseLeftPos = this.f_97735_ + 7;
        int buttonTopPos = this.f_97736_ + 145;
        int buttonLeftPos = buttonBaseLeftPos;
        int buttonSpace = 3;
        int buttonWidth = smallButtons ? 150 : 100;
        int buttonMaxTextLength = smallButtons ? 22 : 14;
        for (DialogButtonData dialogButtonData : this.dialogButtons) {
            if (buttonIndex > 5) break;
            if (smallButtons && buttonIndex == 2 || !smallButtons && buttonIndex == 3) {
                buttonTopPos += 20;
                buttonLeftPos = buttonBaseLeftPos;
            }
            DialogButtonButton dialogActionButton = new DialogButtonButton(buttonLeftPos, buttonTopPos, buttonWidth, dialogButtonData.getName(buttonMaxTextLength), onPress -> {
                log.info("Edit dialog button {}", (Object)dialogButtonData.getId());
                ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.dialogId, dialogButtonData.getId(), ConfigurationType.DIALOG_EDITOR);
            });
            this.m_142416_((GuiEventListener)dialogActionButton);
            buttonLeftPos += buttonWidth + buttonSpace;
            ++buttonIndex;
        }
        if (buttonIndex < 6) {
            this.addDialogButton = new AddButton(this.dialogButtons.size() < 5 && buttonIndex != 2 ? buttonLeftPos : buttonBaseLeftPos, this.dialogButtons.size() < 5 && buttonIndex != 2 ? buttonTopPos : buttonTopPos + 20, smallButtons ? buttonWidth : 150, "dialog.add_button", onPress -> {
                this.saveDialogData();
                ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.dialogId, ConfigurationType.DIALOG_EDITOR);
            });
            this.m_142416_((GuiEventListener)this.addDialogButton);
        }
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.f_97735_ + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.f_93620_ + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialog()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.f_93620_ + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.dialogNameTextField.m_94155_().equals(this.dialogNameValue) || !this.dialogLabelTextField.m_94155_().equals(this.dialogLabelValue) || this.dialogTranslateCheckbox.selected() != this.dialogTranslateValue;
        }
        if (this.dialogLabelCheckbox != null && this.dialogNameToLabelButton != null) {
            this.dialogNameToLabelButton.f_93623_ = !this.dialogLabelCheckbox.selected();
        }
    }

    public void m_7861_() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
        super.m_7861_();
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderEditLabels(poseStack);
        this.xMouse = x;
        this.yMouse = y;
        if (this.dialogNameToLabelButton.m_5953_((double)x, (double)y)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.name_to_label.tooltip"), x, y);
        }
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_, 132, 0, 120, 160);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        this.m_93228_(poseStack, this.f_97735_ + 203, this.f_97736_ + 77, 132, 5, 120, 170);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

