/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Config CLIENT;
    protected static final Logger log;

    private ClientConfig() {
    }

    static {
        log = LogManager.getLogger((String)"Easy NPC");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Config)specPair.getLeft();
        log.info("Registering {} client config ...", (Object)"Easy NPC");
        try {
            FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get(), (String)"easy_npc");
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec, "easy_npc/easy_npc-client.toml");
    }

    public static class Config {
        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Easy NPC");
            builder.push("Client Configuration");
            builder.pop();
        }
    }
}

