/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.action.ActionUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ActionDataEntry {
    public static final int MAX_PERMISSION_LEVEL = 2;
    public static final int DEFAULT_PERMISSION_LEVEL = 2;
    public static final int MIN_PERMISSION_LEVEL = 0;
    public static final String DATA_COMMAND_TAG = "Cmd";
    public static final String DATA_DEBUG_TAG = "Debug";
    public static final String DATA_EXECUTE_AS_USER_TAG = "ExecAsUser";
    public static final String DATA_PERMISSION_LEVEL_TAG = "PermLevel";
    public static final String DATA_TYPE_TAG = "Type";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String DEFAULT_COMMAND = "";
    private ActionType actionType = ActionType.NONE;
    private String command = "";
    private boolean enableDebug = false;
    private boolean executeAsUser = false;
    private int permissionLevel = 2;

    public ActionDataEntry(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public ActionDataEntry(ActionType actionType) {
        this(actionType, DEFAULT_COMMAND, 2);
    }

    public ActionDataEntry(ActionType actionType, String command) {
        this(actionType, command, 2);
    }

    public ActionDataEntry(ActionType actionType, String command, int permissionLevel) {
        this(actionType, command, permissionLevel, false);
    }

    public ActionDataEntry(ActionType actionType, String command, int permissionLevel, boolean executeAsUser) {
        this(actionType, command, permissionLevel, executeAsUser, false);
    }

    public ActionDataEntry(ActionType actionType, String command, boolean executeAsUser, boolean enableDebug) {
        this(actionType, command, 2, executeAsUser, enableDebug);
    }

    public ActionDataEntry(ActionType actionType, String command, int permissionLevel, boolean executeAsUser, boolean enableDebug) {
        this.command = command != null ? command : DEFAULT_COMMAND;
        this.actionType = actionType;
        this.enableDebug = enableDebug;
        this.executeAsUser = executeAsUser;
        this.permissionLevel = permissionLevel;
    }

    public ActionType getType() {
        return this.actionType;
    }

    public void setType(ActionType actionType) {
        this.actionType = actionType;
    }

    public String getCommand() {
        return this.command;
    }

    public String getAction(LivingEntity entity, ServerPlayer serverPlayer) {
        return ActionUtils.parseAction(this.command, entity, serverPlayer);
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int permissionLevel) {
        if (permissionLevel > 2) {
            log.warn("Permission level {} is too high, will be set to a safe max. level {}", (Object)permissionLevel, (Object)2);
            this.permissionLevel = 2;
        } else if (permissionLevel < 0) {
            log.warn("Permission level {} is too low, will be set to min. level {}", (Object)permissionLevel, (Object)0);
            this.permissionLevel = 0;
        } else {
            this.permissionLevel = permissionLevel;
        }
    }

    public boolean shouldExecuteAsUser() {
        return this.executeAsUser;
    }

    public boolean isDebugEnabled() {
        return this.enableDebug;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public boolean hasCommandAndNotEmpty() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean isValid() {
        return this.actionType != ActionType.NONE && this.hasCommand();
    }

    public boolean isValidAndNotEmpty() {
        return this.actionType != ActionType.NONE && (this.hasCommandAndNotEmpty() || this.actionType == ActionType.OPEN_TRADING_SCREEN);
    }

    public void load(CompoundTag compoundTag) {
        this.actionType = ActionType.get(compoundTag.m_128461_(DATA_TYPE_TAG));
        this.command = compoundTag.m_128461_(DATA_COMMAND_TAG);
        this.permissionLevel = compoundTag.m_128441_(DATA_PERMISSION_LEVEL_TAG) ? compoundTag.m_128451_(DATA_PERMISSION_LEVEL_TAG) : 2;
        this.executeAsUser = compoundTag.m_128441_(DATA_EXECUTE_AS_USER_TAG) && compoundTag.m_128471_(DATA_EXECUTE_AS_USER_TAG);
        this.enableDebug = compoundTag.m_128441_(DATA_DEBUG_TAG) && compoundTag.m_128471_(DATA_DEBUG_TAG);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_TYPE_TAG, this.getType().name());
        compoundTag.m_128359_(DATA_COMMAND_TAG, this.getCommand());
        compoundTag.m_128405_(DATA_PERMISSION_LEVEL_TAG, this.getPermissionLevel());
        if (this.shouldExecuteAsUser()) {
            compoundTag.m_128379_(DATA_EXECUTE_AS_USER_TAG, true);
        }
        if (this.isDebugEnabled()) {
            compoundTag.m_128379_(DATA_DEBUG_TAG, true);
        }
        if (this.getPermissionLevel() != 2) {
            compoundTag.m_128405_(DATA_PERMISSION_LEVEL_TAG, this.getPermissionLevel());
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public boolean equals(Object object) {
        if (object instanceof ActionDataEntry) {
            ActionDataEntry actionDataEntry = (ActionDataEntry)object;
            return this.getType() == actionDataEntry.getType() && this.getCommand().equals(actionDataEntry.getCommand()) && this.getPermissionLevel() == actionDataEntry.getPermissionLevel() && this.shouldExecuteAsUser() == actionDataEntry.shouldExecuteAsUser() && this.isDebugEnabled() == actionDataEntry.isDebugEnabled();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.getCommand().hashCode();
        result = 31 * result + this.getPermissionLevel();
        result = 31 * result + (this.shouldExecuteAsUser() ? 1 : 0);
        result = 31 * result + (this.isDebugEnabled() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ActionData [type=" + this.actionType + ", cmd=" + this.command + ", permLvl=" + this.permissionLevel + ", execAsUser=" + this.executeAsUser + ", debug=" + this.enableDebug + "]";
    }
}

