/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ActionUtils {
    public static final String MACRO_NPC_UUID = "@npc-uuid";
    public static final String MACRO_NPC = "@npc";
    public static final String MACRO_INITIATOR_UUID = "@initiator-uuid";
    public static final String MACRO_INITIATOR = "@initiator";
    public static final String MACRO_ERROR_MESSAGE = "/error_message";
    public static final String MACRO_WARN_MESSAGE = "/warn_message";
    public static final String MACRO_INFO_MESSAGE = "/info_message";
    public static final String MACRO_SUCCESS_MESSAGE = "/success_message";
    public static final String COMMAND_DISPLAY_TITLE = "/title @initiator title {\"text\":\"";

    private ActionUtils() {
    }

    public static String parseAction(String command, LivingEntity entity, ServerPlayer player) {
        if (command == null || ((String)command).isEmpty()) {
            return "";
        }
        Object output = command;
        if (!((String)command).startsWith("/")) {
            command = "/" + (String)command;
        }
        if (((String)command).startsWith(MACRO_ERROR_MESSAGE)) {
            output = ((String)output).replace(MACRO_ERROR_MESSAGE, "").replace("\"", "").trim();
            output = COMMAND_DISPLAY_TITLE + (String)output + "\",\"color\":\"dark_red\"}";
        } else if (((String)command).startsWith(MACRO_WARN_MESSAGE)) {
            output = ((String)output).replace(MACRO_WARN_MESSAGE, "").replace("\"", "").trim();
            output = COMMAND_DISPLAY_TITLE + (String)output + "\",\"color\":\"yellow\"}";
        } else if (((String)command).startsWith(MACRO_INFO_MESSAGE)) {
            output = ((String)output).replace(MACRO_INFO_MESSAGE, "").replace("\"", "").trim();
            output = COMMAND_DISPLAY_TITLE + (String)output + "\",\"color\":\"aqua\"}";
        } else if (((String)command).startsWith(MACRO_SUCCESS_MESSAGE)) {
            output = ((String)output).replace(MACRO_SUCCESS_MESSAGE, "").replace("\"", "").trim();
            output = COMMAND_DISPLAY_TITLE + (String)output + "\",\"color\":\"green\"}";
        }
        if (entity != null) {
            output = ((String)output).replace(MACRO_NPC_UUID, entity.m_20148_().toString());
            output = ((String)output).replace(MACRO_NPC, entity.m_7755_().getString());
        }
        if (player != null) {
            output = ((String)output).replace(MACRO_INITIATOR_UUID, player.m_20148_().toString());
            output = ((String)output).replace(MACRO_INITIATOR, player.m_7755_().getString());
        }
        return output;
    }
}

