/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DialogButtonData {
    public static final int MAX_BUTTON_LABEL_LENGTH = 32;
    public static final String DATA_ACTIONS_TAG = "Actions";
    public static final String DATA_BUTTON_NAME_TAG = "Name";
    public static final String DATA_TRANSLATE_TAG = "Translate";
    public static final String DATA_TYPE_TAG = "Type";
    public static final String DATA_LABEL_TAG = "Label";
    private Set<ActionDataEntry> actionDatumEntries = new LinkedHashSet<ActionDataEntry>();
    private UUID id;
    private String label = "";
    private DialogButtonType type;
    private String name;
    private boolean translate;

    public DialogButtonData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public DialogButtonData(String name, String label, Set<ActionDataEntry> actionDatumEntries) {
        this(name, label, DialogButtonType.DEFAULT, actionDatumEntries, false);
    }

    public DialogButtonData(String name, DialogButtonType type) {
        this(name, null, type, new LinkedHashSet<ActionDataEntry>(), false);
    }

    public DialogButtonData(String name, String label, DialogButtonType type, Set<ActionDataEntry> actionDatumEntries, boolean translate) {
        this.name = name;
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
        this.type = type;
        this.actionDatumEntries = actionDatumEntries != null ? actionDatumEntries : new LinkedHashSet();
        this.translate = translate;
    }

    public UUID getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : this.name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    public String getName(int maxLength) {
        return this.name.length() > maxLength ? this.name.substring(0, maxLength - 1) + "\u2026" : this.name;
    }

    public Component getButtonName(int maxLength) {
        MutableComponent buttonName;
        MutableComponent mutableComponent = buttonName = this.translate ? Component.m_237115_((String)this.name) : Component.m_237113_((String)this.name);
        if (buttonName.getString().length() > maxLength) {
            buttonName = Component.m_237113_((String)(buttonName.getString().substring(0, maxLength - 1) + "\u2026"));
        }
        return buttonName;
    }

    public DialogButtonType getType() {
        return this.type;
    }

    public boolean hasActionData() {
        if (this.actionDatumEntries == null || this.actionDatumEntries.isEmpty()) {
            return false;
        }
        for (ActionDataEntry action : this.actionDatumEntries) {
            if (!action.isValidAndNotEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<ActionDataEntry> getActionData() {
        return this.actionDatumEntries;
    }

    public void setActionData(Set<ActionDataEntry> actionDatumEntries) {
        this.actionDatumEntries = actionDatumEntries == null ? new LinkedHashSet() : actionDatumEntries;
    }

    public Set<ActionDataEntry> getAllActionData(ActionType actionType) {
        LinkedHashSet<ActionDataEntry> actionDataEntrySet = new LinkedHashSet<ActionDataEntry>();
        for (ActionDataEntry action : this.actionDatumEntries) {
            if (action.getType() != actionType) continue;
            actionDataEntrySet.add(action);
        }
        return actionDataEntrySet;
    }

    public ActionDataEntry getActionData(ActionType actionType) {
        for (ActionDataEntry action : this.actionDatumEntries) {
            if (action.getType() != actionType) continue;
            return action;
        }
        return null;
    }

    public boolean getTranslate() {
        return this.translate;
    }

    public void load(CompoundTag compoundTag) {
        this.name = compoundTag.m_128461_(DATA_BUTTON_NAME_TAG);
        this.type = DialogButtonType.get(compoundTag.m_128461_(DATA_TYPE_TAG));
        boolean bl = this.translate = compoundTag.m_128441_(DATA_TRANSLATE_TAG) && compoundTag.m_128471_(DATA_TRANSLATE_TAG);
        if (compoundTag.m_128441_(DATA_LABEL_TAG)) {
            this.setLabel(compoundTag.m_128461_(DATA_LABEL_TAG));
        } else {
            this.setLabel(this.name);
        }
        ListTag actionDataList = compoundTag.m_128437_(DATA_ACTIONS_TAG, 10);
        this.actionDatumEntries.clear();
        for (int i = 0; i < actionDataList.size(); ++i) {
            this.actionDatumEntries.add(new ActionDataEntry(actionDataList.m_128728_(i)));
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_BUTTON_NAME_TAG, this.name.trim());
        compoundTag.m_128359_(DATA_TYPE_TAG, this.type.name());
        if (!Objects.equals(DialogUtils.generateButtonLabel(this.name), this.label)) {
            compoundTag.m_128359_(DATA_LABEL_TAG, this.label);
        }
        if (this.translate) {
            compoundTag.m_128379_(DATA_TRANSLATE_TAG, true);
        }
        ListTag actionDataList = new ListTag();
        for (ActionDataEntry action : this.actionDatumEntries) {
            actionDataList.add((Object)action.save(new CompoundTag()));
        }
        compoundTag.m_128365_(DATA_ACTIONS_TAG, (Tag)actionDataList);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "DialogButtonData [id=" + this.id + ", name=" + this.name + ", label=" + this.label + ", type=" + this.type + ", translate=" + this.translate + ", actionData=" + this.actionDatumEntries + "]";
    }
}

