/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class DialogDataEntry {
    public static final int MAX_DIALOG_LABEL_LENGTH = 32;
    public static final String DATA_BUTTONS_TAG = "Buttons";
    public static final String DATA_DIALOG_NAME = "Name";
    public static final String DATA_LABEL_TAG = "Label";
    public static final String DATA_TEXT_TAG = "Text";
    public static final String DATA_TEXTS_TAG = "Texts";
    public static final String DATA_TRANSLATE_TAG = "Translate";
    private UUID id;
    private String label = "";
    private String name;
    private boolean translate;
    private Set<DialogTextData> dialogTexts = new LinkedHashSet<DialogTextData>();
    private Set<DialogButtonData> buttons = new LinkedHashSet<DialogButtonData>();

    public DialogDataEntry(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public DialogDataEntry(String name) {
        this(null, name, "Dialog text", false, null);
    }

    public DialogDataEntry(String name, String text, boolean translate) {
        this("default", name, text, translate, null);
    }

    public DialogDataEntry(String label, String name, String text, boolean translate) {
        this(label, name, text, translate, null);
    }

    public DialogDataEntry(String label, String name, String text, boolean translate, Set<DialogButtonData> buttons) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : name);
        this.name = name != null ? name.trim() : this.label;
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
        this.buttons = buttons != null ? buttons : new LinkedHashSet();
        this.dialogTexts.add(new DialogTextData(text, translate));
    }

    public UUID getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : this.name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
    }

    public String getLabel(int maxLength) {
        return this.label.length() > maxLength ? this.label.substring(0, maxLength - 1) + "\u2026" : this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    public String getName(int maxLength) {
        return this.name.length() > maxLength ? this.name.substring(0, maxLength - 1) + "\u2026" : this.name;
    }

    public String getText() {
        return ((DialogTextData)this.dialogTexts.stream().findFirst().get()).getText();
    }

    public void setText(String text) {
        this.dialogTexts.clear();
        this.dialogTexts.add(new DialogTextData(text));
    }

    public void setText(String text, UUID dialogTextId) {
        for (DialogTextData dialogText : this.dialogTexts) {
            if (!dialogText.getId().equals(dialogTextId)) continue;
            dialogText.setText(text);
            return;
        }
    }

    public String getDialogText() {
        if (this.dialogTexts == null || this.dialogTexts.isEmpty()) {
            return "";
        }
        DialogTextData dialogText = this.dialogTexts.size() == 1 ? (DialogTextData)this.dialogTexts.stream().findFirst().orElse(null) : (DialogTextData)this.dialogTexts.stream().skip(ThreadLocalRandom.current().nextInt(this.dialogTexts.size())).findFirst().orElse(null);
        return dialogText != null ? dialogText.getDialogText() : "";
    }

    public String getText(int maxLength) {
        return ((DialogTextData)this.dialogTexts.stream().findFirst().get()).getText(maxLength);
    }

    public String getDialogText(LivingEntity entity, Player player) {
        return DialogUtils.parseDialogText(this.getDialogText(), entity, player);
    }

    public DialogTextData getDialogText(UUID dialogTextId) {
        for (DialogTextData dialogText : this.dialogTexts) {
            if (!dialogText.getId().equals(dialogTextId)) continue;
            return dialogText;
        }
        return null;
    }

    public Set<DialogTextData> getDialogTexts() {
        return this.dialogTexts;
    }

    public void setDialogTexts(Set<DialogTextData> dialogTexts) {
        this.dialogTexts = dialogTexts;
    }

    public int getRandomDialogIndex() {
        return ThreadLocalRandom.current().nextInt(this.dialogTexts.size());
    }

    public boolean getTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public Set<DialogButtonData> getButtons() {
        return this.buttons;
    }

    public void setButtons(Set<DialogButtonData> buttons) {
        this.buttons = buttons;
    }

    public DialogButtonData getButton(UUID dialogButtonId) {
        for (DialogButtonData button : this.buttons) {
            if (!button.getId().equals(dialogButtonId)) continue;
            return button;
        }
        return null;
    }

    public DialogButtonData getButton(String label) {
        for (DialogButtonData button : this.buttons) {
            if (!button.getLabel().equals(label)) continue;
            return button;
        }
        return null;
    }

    public void setButton(DialogButtonData dialogButtonData) {
        this.setButton(dialogButtonData.getId(), dialogButtonData);
    }

    public void setButton(UUID dialogButtonId, DialogButtonData dialogButtonData) {
        if (dialogButtonId != null) {
            for (DialogButtonData button : this.buttons) {
                if (!button.getId().equals(dialogButtonId)) continue;
                this.buttons.remove(button);
                this.buttons.add(dialogButtonData);
                return;
            }
        }
        this.buttons.add(dialogButtonData);
    }

    public boolean hasButton(String label) {
        for (DialogButtonData button : this.buttons) {
            if (!button.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    public boolean hasButton(UUID dialogButtonId) {
        for (DialogButtonData button : this.buttons) {
            if (!button.getId().equals(dialogButtonId)) continue;
            return true;
        }
        return false;
    }

    public boolean removeButton(UUID dialogButtonId) {
        for (DialogButtonData button : this.buttons) {
            if (!button.getId().equals(dialogButtonId)) continue;
            this.buttons.remove(button);
            return true;
        }
        return false;
    }

    public int getNumberOfButtons() {
        return this.buttons.size();
    }

    public void load(CompoundTag compoundTag) {
        int i;
        this.name = compoundTag.m_128461_(DATA_DIALOG_NAME);
        if (compoundTag.m_128441_(DATA_LABEL_TAG)) {
            this.setLabel(compoundTag.m_128461_(DATA_LABEL_TAG));
        } else {
            this.setLabel(this.name);
        }
        if (compoundTag.m_128441_(DATA_TEXTS_TAG)) {
            this.dialogTexts.clear();
            ListTag dialogTextsList = compoundTag.m_128437_(DATA_TEXTS_TAG, 10);
            if (!dialogTextsList.isEmpty()) {
                for (i = 0; i < dialogTextsList.size(); ++i) {
                    this.dialogTexts.add(new DialogTextData(dialogTextsList.m_128728_(i)));
                }
            }
        } else if (compoundTag.m_128441_(DATA_TEXT_TAG)) {
            this.dialogTexts.clear();
            this.dialogTexts.add(new DialogTextData(compoundTag.m_128461_(DATA_TEXT_TAG), compoundTag.m_128441_(DATA_TRANSLATE_TAG) && compoundTag.m_128471_(DATA_TRANSLATE_TAG)));
        }
        if (compoundTag.m_128441_(DATA_BUTTONS_TAG)) {
            this.buttons.clear();
            ListTag buttonsList = compoundTag.m_128437_(DATA_BUTTONS_TAG, 10);
            if (!buttonsList.isEmpty()) {
                for (i = 0; i < buttonsList.size(); ++i) {
                    this.buttons.add(new DialogButtonData(buttonsList.m_128728_(i)));
                }
            }
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_DIALOG_NAME, this.name.trim());
        if (!Objects.equals(DialogUtils.generateDialogLabel(this.name), this.label)) {
            compoundTag.m_128359_(DATA_LABEL_TAG, this.label);
        }
        if (this.translate) {
            compoundTag.m_128379_(DATA_TRANSLATE_TAG, true);
        }
        if (this.dialogTexts != null && !this.dialogTexts.isEmpty()) {
            ListTag dialogTextsList = new ListTag();
            for (DialogTextData dialogText : this.dialogTexts) {
                dialogTextsList.add((Object)dialogText.save(new CompoundTag()));
            }
            compoundTag.m_128365_(DATA_TEXTS_TAG, (Tag)dialogTextsList);
        }
        if (this.buttons != null) {
            ListTag buttonsList = new ListTag();
            for (DialogButtonData button : this.buttons) {
                buttonsList.add((Object)button.save(new CompoundTag()));
            }
            compoundTag.m_128365_(DATA_BUTTONS_TAG, (Tag)buttonsList);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "DialogData [id=" + this.id + ", name=" + this.name + ", label=" + this.label + ", translate=" + this.translate + ", texts=" + this.dialogTexts + ", buttons=" + this.buttons + "]";
    }
}

