/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

public enum SkinModel {
    ALLAY,
    CAT,
    CHICKEN,
    FAIRY,
    HUMANOID(true),
    HUMANOID_SLIM(true),
    ILLAGER,
    IRON_GOLEM,
    ORC,
    PIG,
    WOLF,
    SKELETON(true),
    VILLAGER(true),
    ZOMBIE(true),
    ZOMBIE_VILLAGER(true);

    private final boolean hasArmourersWorkshopSupport;

    private SkinModel() {
        this(false);
    }

    private SkinModel(boolean hasArmourersWorkshopSupport) {
        this.hasArmourersWorkshopSupport = hasArmourersWorkshopSupport;
    }

    public static SkinModel get(String skinModel) {
        if (skinModel == null || skinModel.isEmpty()) {
            return HUMANOID;
        }
        try {
            return SkinModel.valueOf(skinModel);
        }
        catch (IllegalArgumentException e) {
            return HUMANOID;
        }
    }

    public boolean hasArmourersWorkshopSupport() {
        return this.hasArmourersWorkshopSupport;
    }

    public String getName() {
        return this.name().toLowerCase().replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "");
    }
}

