/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCBaseEntity<E extends PathfinderMob>
extends PathfinderMob
implements EasyNPCBase<E> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final EnumMap<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private final ServerEntityData serverEntityData = new ServerEntityData((Entity)this);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    protected MerchantOffers offers;
    private SynchedEntityData synchedEntityData;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private int npcDataVersion = -1;
    private Player tradingPlayer;
    private int attackAnimationTick;

    public EasyNPCBaseEntity(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level);
        this.registerEasyNPCDefaultHandler(variant);
        this.m_20331_(true);
        this.refreshGroundNavigation();
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    public void m_7822_(byte flag) {
        super.m_7822_(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_183595_()) {
            this.m_21203_();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    @Override
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @Override
    public void m_7189_(Player player) {
        this.tradingPlayer = player;
    }

    @Override
    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(merchantOffer);
        Player player = this.tradingPlayer;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            log.debug("Trade {} with {} for {}", (Object)merchantOffer, (Object)serverPlayer, (Object)this);
        }
    }

    @Override
    public void m_7713_(ItemStack itemStack) {
        if (!this.m_183595_() && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.playDefaultTradeUpdatedSound(!itemStack.m_41619_());
        }
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.m_45383_() && merchantOffer.m_45379_() > 0) {
            int tradeExperience = 3 + this.f_19796_.m_188503_(merchantOffer.m_45379_());
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), tradeExperience));
        }
    }

    public Component m_7755_() {
        Component component = this.m_7770_();
        return component != null ? TextUtils.removeAction(component) : this.m_5677_();
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.m_6469_(damageSource, damage);
    }

    public void m_6667_(DamageSource damageSource) {
        this.handleDieEvent(damageSource);
        super.m_6667_(damageSource);
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        this.handleChangeDimensionEvent(serverLevel);
        return super.m_5489_(serverLevel);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    @Override
    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.updateTradesData();
        }
        return this.offers;
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    @Override
    public void updateTradesData() {
        MerchantOffers merchantOffers = null;
        if (this.getTradingType() == TradingType.BASIC || this.getTradingType() == TradingType.ADVANCED) {
            merchantOffers = new MerchantOffers(this.getTradingOffers().m_45388_());
        }
        if (merchantOffers != null && !merchantOffers.isEmpty()) {
            merchantOffers.removeIf(merchantOffer -> merchantOffer.m_45352_().m_41619_() && merchantOffer.m_45364_().m_41619_() || merchantOffer.m_45368_().m_41619_());
            this.offers = merchantOffers;
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        log.debug("FinalizeSpawn for {} with spawnGroupData {} at {}", (Object)this, (Object)spawnGroupData, (Object)this.m_20183_());
        this.setHomePosition(this.m_20183_());
        if (!this.hasObjectives()) {
            this.registerStandardObjectives();
        }
        return spawnGroupData;
    }

    @Override
    public void handleEasyNPCJoin(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeave(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoin(ServerPlayer serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeave(ServerPlayer serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoin(LivingEntity livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeave(LivingEntity livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    public GoalSelector getEntityGoalSelector() {
        return this.f_21345_;
    }

    @Override
    public GoalSelector getEntityTargetSelector() {
        return this.f_21346_;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((Entity)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data) {
        this.synchedEntityData.set(synchedDataIndex, data);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public <T> void setServerEntityData(ServerDataAccessor<T> entityDataAccessor, T entityData) {
        this.serverEntityData.set(entityDataAccessor, entityData);
    }

    @Override
    public <T> T getServerEntityData(ServerDataAccessor<T> entityDataAccessor) {
        return this.serverEntityData.get(entityDataAccessor);
    }

    @Override
    public <T> void defineServerEntityData(ServerDataAccessor<T> entityDataAccessor, T entityData) {
        this.serverEntityData.define(entityDataAccessor, entityData);
    }

    public boolean m_6573_(Player player) {
        ServerPlayer serverPlayer;
        if (!this.m_21523_() && player instanceof ServerPlayer && ((serverPlayer = (ServerPlayer)player).m_7500_() || this.isOwner(serverPlayer))) {
            return true;
        }
        return !this.m_21523_() && this.getAttributeDataLoaded() && this.getAttributeCanBeLeashed() && !(this instanceof Enemy);
    }

    public boolean m_6097_() {
        return this.getAttributeDataLoaded() && this.getAttributeIsAttackable();
    }

    public boolean m_6094_() {
        return this.getAttributeDataLoaded() && this.getAttributeIsPushable();
    }

    protected void m_6138_() {
        if (this.getAttributeDataLoaded() && this.getAttributePushEntities()) {
            super.m_6138_();
        }
    }

    public boolean m_20147_() {
        return this.getAttributeDataLoaded() ? !this.getAttributeIsAttackable() : super.m_20147_();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return this.m_20147_() || super.m_6673_(damageSource);
    }

    public void m_8032_() {
        this.playDefaultAmbientSound();
    }

    public int m_8100_() {
        return 240;
    }

    public void m_6677_(DamageSource damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public SoundEvent m_5592_() {
        return this.getDefaultDeathSound();
    }

    protected void m_20157_() {
        if (this.getAttributeDataLoaded() && this.getAttributeCanUseNetherPortal()) {
            super.m_20157_();
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_183595_() || !this.m_6084_()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void m_7023_(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.m_7023_(vec3);
        } else {
            this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
        }
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_5853_(SoundSource soundSource) {
        if (soundSource != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.defineEasyNPCBaseSyncedData();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_21678_(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_147285_(this.f_19853_, compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBaseEntity)) {
            return false;
        }
        EasyNPCBaseEntity easyNPCBaseEntity = (EasyNPCBaseEntity)object;
        return Objects.equals(this.m_20148_(), easyNPCBaseEntity.m_20148_());
    }

    public int hashCode() {
        return Objects.hash(this.m_20148_());
    }

    static {
        EasyNPCBase.registerEasyNPCDataSerializers();
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, EasyNPCBaseEntity.class);
    }
}

